/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsResponse;

public class ListFirewallRuleGroupsIterable
implements SdkIterable<ListFirewallRuleGroupsResponse> {
    private final Route53ResolverClient client;
    private final ListFirewallRuleGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFirewallRuleGroupsIterable(Route53ResolverClient client, ListFirewallRuleGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFirewallRuleGroupsResponseFetcher();
    }

    public Iterator<ListFirewallRuleGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FirewallRuleGroupMetadata> firewallRuleGroups() {
        Function<ListFirewallRuleGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallRuleGroups() != null) {
                return response.firewallRuleGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFirewallRuleGroupsResponseFetcher
    implements SyncPageFetcher<ListFirewallRuleGroupsResponse> {
        private ListFirewallRuleGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallRuleGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFirewallRuleGroupsResponse nextPage(ListFirewallRuleGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallRuleGroupsIterable.this.client.listFirewallRuleGroups(ListFirewallRuleGroupsIterable.this.firstRequest);
            }
            return ListFirewallRuleGroupsIterable.this.client.listFirewallRuleGroups((ListFirewallRuleGroupsRequest)((Object)ListFirewallRuleGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

