/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig;

public class ListResolverDnssecConfigsIterable
implements SdkIterable<ListResolverDnssecConfigsResponse> {
    private final Route53ResolverClient client;
    private final ListResolverDnssecConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResolverDnssecConfigsIterable(Route53ResolverClient client, ListResolverDnssecConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResolverDnssecConfigsResponseFetcher();
    }

    public Iterator<ListResolverDnssecConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResolverDnssecConfig> resolverDnssecConfigs() {
        Function<ListResolverDnssecConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolverDnssecConfigs() != null) {
                return response.resolverDnssecConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResolverDnssecConfigsResponseFetcher
    implements SyncPageFetcher<ListResolverDnssecConfigsResponse> {
        private ListResolverDnssecConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverDnssecConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResolverDnssecConfigsResponse nextPage(ListResolverDnssecConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverDnssecConfigsIterable.this.client.listResolverDnssecConfigs(ListResolverDnssecConfigsIterable.this.firstRequest);
            }
            return ListResolverDnssecConfigsIterable.this.client.listResolverDnssecConfigs((ListResolverDnssecConfigsRequest)((Object)ListResolverDnssecConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

