/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ParallelismConfiguration;
import software.amazon.awssdk.services.sagemaker.model.PipelineStatus;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Pipeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Pipeline> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineArn").getter(Pipeline.getter(Pipeline::pipelineArn)).setter(Pipeline.setter(Builder::pipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()}).build();
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineName").getter(Pipeline.getter(Pipeline::pipelineName)).setter(Pipeline.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()}).build();
    private static final SdkField<String> PIPELINE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDisplayName").getter(Pipeline.getter(Pipeline::pipelineDisplayName)).setter(Pipeline.setter(Builder::pipelineDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDisplayName").build()}).build();
    private static final SdkField<String> PIPELINE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineDescription").getter(Pipeline.getter(Pipeline::pipelineDescription)).setter(Pipeline.setter(Builder::pipelineDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDescription").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(Pipeline.getter(Pipeline::roleArn)).setter(Pipeline.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> PIPELINE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineStatus").getter(Pipeline.getter(Pipeline::pipelineStatusAsString)).setter(Pipeline.setter(Builder::pipelineStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Pipeline.getter(Pipeline::creationTime)).setter(Pipeline.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Pipeline.getter(Pipeline::lastModifiedTime)).setter(Pipeline.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Instant> LAST_RUN_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastRunTime").getter(Pipeline.getter(Pipeline::lastRunTime)).setter(Pipeline.setter(Builder::lastRunTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(Pipeline.getter(Pipeline::createdBy)).setter(Pipeline.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(Pipeline.getter(Pipeline::lastModifiedBy)).setter(Pipeline.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<ParallelismConfiguration> PARALLELISM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParallelismConfiguration").getter(Pipeline.getter(Pipeline::parallelismConfiguration)).setter(Pipeline.setter(Builder::parallelismConfiguration)).constructor(ParallelismConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Pipeline.getter(Pipeline::tags)).setter(Pipeline.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD, PIPELINE_NAME_FIELD, PIPELINE_DISPLAY_NAME_FIELD, PIPELINE_DESCRIPTION_FIELD, ROLE_ARN_FIELD, PIPELINE_STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_RUN_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_BY_FIELD, PARALLELISM_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pipelineArn;
    private final String pipelineName;
    private final String pipelineDisplayName;
    private final String pipelineDescription;
    private final String roleArn;
    private final String pipelineStatus;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final Instant lastRunTime;
    private final UserContext createdBy;
    private final UserContext lastModifiedBy;
    private final ParallelismConfiguration parallelismConfiguration;
    private final List<Tag> tags;

    private Pipeline(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.pipelineName = builder.pipelineName;
        this.pipelineDisplayName = builder.pipelineDisplayName;
        this.pipelineDescription = builder.pipelineDescription;
        this.roleArn = builder.roleArn;
        this.pipelineStatus = builder.pipelineStatus;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastRunTime = builder.lastRunTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.parallelismConfiguration = builder.parallelismConfiguration;
        this.tags = builder.tags;
    }

    public final String pipelineArn() {
        return this.pipelineArn;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final String pipelineDisplayName() {
        return this.pipelineDisplayName;
    }

    public final String pipelineDescription() {
        return this.pipelineDescription;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final PipelineStatus pipelineStatus() {
        return PipelineStatus.fromValue(this.pipelineStatus);
    }

    public final String pipelineStatusAsString() {
        return this.pipelineStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Instant lastRunTime() {
        return this.lastRunTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final ParallelismConfiguration parallelismConfiguration() {
        return this.parallelismConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelismConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pipeline)) {
            return false;
        }
        Pipeline other = (Pipeline)obj;
        return Objects.equals(this.pipelineArn(), other.pipelineArn()) && Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineDisplayName(), other.pipelineDisplayName()) && Objects.equals(this.pipelineDescription(), other.pipelineDescription()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.pipelineStatusAsString(), other.pipelineStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastRunTime(), other.lastRunTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.parallelismConfiguration(), other.parallelismConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Pipeline").add("PipelineArn", (Object)this.pipelineArn()).add("PipelineName", (Object)this.pipelineName()).add("PipelineDisplayName", (Object)this.pipelineDisplayName()).add("PipelineDescription", (Object)this.pipelineDescription()).add("RoleArn", (Object)this.roleArn()).add("PipelineStatus", (Object)this.pipelineStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastRunTime", (Object)this.lastRunTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("ParallelismConfiguration", (Object)this.parallelismConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineArn()));
            }
            case "PipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "PipelineDisplayName": {
                return Optional.ofNullable(clazz.cast(this.pipelineDisplayName()));
            }
            case "PipelineDescription": {
                return Optional.ofNullable(clazz.cast(this.pipelineDescription()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "PipelineStatus": {
                return Optional.ofNullable(clazz.cast(this.pipelineStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastRunTime": {
                return Optional.ofNullable(clazz.cast(this.lastRunTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "ParallelismConfiguration": {
                return Optional.ofNullable(clazz.cast(this.parallelismConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Pipeline, T> g) {
        return obj -> g.apply((Pipeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineArn;
        private String pipelineName;
        private String pipelineDisplayName;
        private String pipelineDescription;
        private String roleArn;
        private String pipelineStatus;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private Instant lastRunTime;
        private UserContext createdBy;
        private UserContext lastModifiedBy;
        private ParallelismConfiguration parallelismConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Pipeline model) {
            this.pipelineArn(model.pipelineArn);
            this.pipelineName(model.pipelineName);
            this.pipelineDisplayName(model.pipelineDisplayName);
            this.pipelineDescription(model.pipelineDescription);
            this.roleArn(model.roleArn);
            this.pipelineStatus(model.pipelineStatus);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastRunTime(model.lastRunTime);
            this.createdBy(model.createdBy);
            this.lastModifiedBy(model.lastModifiedBy);
            this.parallelismConfiguration(model.parallelismConfiguration);
            this.tags(model.tags);
        }

        public final String getPipelineArn() {
            return this.pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        @Transient
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        @Transient
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getPipelineDisplayName() {
            return this.pipelineDisplayName;
        }

        public final void setPipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
        }

        @Override
        @Transient
        public final Builder pipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
            return this;
        }

        public final String getPipelineDescription() {
            return this.pipelineDescription;
        }

        public final void setPipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
        }

        @Override
        @Transient
        public final Builder pipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getPipelineStatus() {
            return this.pipelineStatus;
        }

        public final void setPipelineStatus(String pipelineStatus) {
            this.pipelineStatus = pipelineStatus;
        }

        @Override
        @Transient
        public final Builder pipelineStatus(String pipelineStatus) {
            this.pipelineStatus = pipelineStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder pipelineStatus(PipelineStatus pipelineStatus) {
            this.pipelineStatus(pipelineStatus == null ? null : pipelineStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getLastRunTime() {
            return this.lastRunTime;
        }

        public final void setLastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
        }

        @Override
        @Transient
        public final Builder lastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        @Transient
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        @Transient
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final ParallelismConfiguration.Builder getParallelismConfiguration() {
            return this.parallelismConfiguration != null ? this.parallelismConfiguration.toBuilder() : null;
        }

        public final void setParallelismConfiguration(ParallelismConfiguration.BuilderImpl parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration != null ? parallelismConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Pipeline build() {
            return new Pipeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Pipeline> {
        public Builder pipelineArn(String var1);

        public Builder pipelineName(String var1);

        public Builder pipelineDisplayName(String var1);

        public Builder pipelineDescription(String var1);

        public Builder roleArn(String var1);

        public Builder pipelineStatus(String var1);

        public Builder pipelineStatus(PipelineStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastRunTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }

        public Builder parallelismConfiguration(ParallelismConfiguration var1);

        default public Builder parallelismConfiguration(Consumer<ParallelismConfiguration.Builder> parallelismConfiguration) {
            return this.parallelismConfiguration((ParallelismConfiguration)((ParallelismConfiguration.Builder)ParallelismConfiguration.builder().applyMutation(parallelismConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

