/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineDefinitionS3Location
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineDefinitionS3Location> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(PipelineDefinitionS3Location.getter(PipelineDefinitionS3Location::bucket)).setter(PipelineDefinitionS3Location.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()}).build();
    private static final SdkField<String> OBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectKey").getter(PipelineDefinitionS3Location.getter(PipelineDefinitionS3Location::objectKey)).setter(PipelineDefinitionS3Location.setter(Builder::objectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKey").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(PipelineDefinitionS3Location.getter(PipelineDefinitionS3Location::versionId)).setter(PipelineDefinitionS3Location.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, OBJECT_KEY_FIELD, VERSION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String objectKey;
    private final String versionId;

    private PipelineDefinitionS3Location(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.objectKey = builder.objectKey;
        this.versionId = builder.versionId;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String objectKey() {
        return this.objectKey;
    }

    public final String versionId() {
        return this.versionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDefinitionS3Location)) {
            return false;
        }
        PipelineDefinitionS3Location other = (PipelineDefinitionS3Location)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.objectKey(), other.objectKey()) && Objects.equals(this.versionId(), other.versionId());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineDefinitionS3Location").add("Bucket", (Object)this.bucket()).add("ObjectKey", (Object)this.objectKey()).add("VersionId", (Object)this.versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "ObjectKey": {
                return Optional.ofNullable(clazz.cast(this.objectKey()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineDefinitionS3Location, T> g) {
        return obj -> g.apply((PipelineDefinitionS3Location)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String objectKey;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineDefinitionS3Location model) {
            this.bucket(model.bucket);
            this.objectKey(model.objectKey);
            this.versionId(model.versionId);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        @Transient
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getObjectKey() {
            return this.objectKey;
        }

        public final void setObjectKey(String objectKey) {
            this.objectKey = objectKey;
        }

        @Override
        @Transient
        public final Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        @Transient
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public PipelineDefinitionS3Location build() {
            return new PipelineDefinitionS3Location(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineDefinitionS3Location> {
        public Builder bucket(String var1);

        public Builder objectKey(String var1);

        public Builder versionId(String var1);
    }
}

