/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.StandardsSubscriptionArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEnabledStandardsRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, GetEnabledStandardsRequest> {
    private static final SdkField<List<String>> STANDARDS_SUBSCRIPTION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StandardsSubscriptionArns").getter(GetEnabledStandardsRequest.getter(GetEnabledStandardsRequest::standardsSubscriptionArns)).setter(GetEnabledStandardsRequest.setter(Builder::standardsSubscriptionArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsSubscriptionArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetEnabledStandardsRequest.getter(GetEnabledStandardsRequest::nextToken)).setter(GetEnabledStandardsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetEnabledStandardsRequest.getter(GetEnabledStandardsRequest::maxResults)).setter(GetEnabledStandardsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_SUBSCRIPTION_ARNS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> standardsSubscriptionArns;
    private final String nextToken;
    private final Integer maxResults;

    private GetEnabledStandardsRequest(BuilderImpl builder) {
        super(builder);
        this.standardsSubscriptionArns = builder.standardsSubscriptionArns;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasStandardsSubscriptionArns() {
        return this.standardsSubscriptionArns != null && !(this.standardsSubscriptionArns instanceof SdkAutoConstructList);
    }

    public final List<String> standardsSubscriptionArns() {
        return this.standardsSubscriptionArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandardsSubscriptionArns() ? this.standardsSubscriptionArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnabledStandardsRequest)) {
            return false;
        }
        GetEnabledStandardsRequest other = (GetEnabledStandardsRequest)((Object)obj);
        return this.hasStandardsSubscriptionArns() == other.hasStandardsSubscriptionArns() && Objects.equals(this.standardsSubscriptionArns(), other.standardsSubscriptionArns()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetEnabledStandardsRequest").add("StandardsSubscriptionArns", this.hasStandardsSubscriptionArns() ? this.standardsSubscriptionArns() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsSubscriptionArns": {
                return Optional.ofNullable(clazz.cast(this.standardsSubscriptionArns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnabledStandardsRequest, T> g) {
        return obj -> g.apply((GetEnabledStandardsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private List<String> standardsSubscriptionArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnabledStandardsRequest model) {
            super(model);
            this.standardsSubscriptionArns(model.standardsSubscriptionArns);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getStandardsSubscriptionArns() {
            if (this.standardsSubscriptionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.standardsSubscriptionArns;
        }

        public final void setStandardsSubscriptionArns(Collection<String> standardsSubscriptionArns) {
            this.standardsSubscriptionArns = StandardsSubscriptionArnsCopier.copy(standardsSubscriptionArns);
        }

        @Override
        @Transient
        public final Builder standardsSubscriptionArns(Collection<String> standardsSubscriptionArns) {
            this.standardsSubscriptionArns = StandardsSubscriptionArnsCopier.copy(standardsSubscriptionArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder standardsSubscriptionArns(String ... standardsSubscriptionArns) {
            this.standardsSubscriptionArns(Arrays.asList(standardsSubscriptionArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEnabledStandardsRequest build() {
            return new GetEnabledStandardsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEnabledStandardsRequest> {
        public Builder standardsSubscriptionArns(Collection<String> var1);

        public Builder standardsSubscriptionArns(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

