/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Member
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Member> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(Member.getter(Member::accountId)).setter(Member.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(Member.getter(Member::email)).setter(Member.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> MASTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterId").getter(Member.getter(Member::masterId)).setter(Member.setter(Builder::masterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterId").build()}).build();
    private static final SdkField<String> ADMINISTRATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdministratorId").getter(Member.getter(Member::administratorId)).setter(Member.setter(Builder::administratorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministratorId").build()}).build();
    private static final SdkField<String> MEMBER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberStatus").getter(Member.getter(Member::memberStatus)).setter(Member.setter(Builder::memberStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberStatus").build()}).build();
    private static final SdkField<Instant> INVITED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InvitedAt").getter(Member.getter(Member::invitedAt)).setter(Member.setter(Builder::invitedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(Member.getter(Member::updatedAt)).setter(Member.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, EMAIL_FIELD, MASTER_ID_FIELD, ADMINISTRATOR_ID_FIELD, MEMBER_STATUS_FIELD, INVITED_AT_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String email;
    private final String masterId;
    private final String administratorId;
    private final String memberStatus;
    private final Instant invitedAt;
    private final Instant updatedAt;

    private Member(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.email = builder.email;
        this.masterId = builder.masterId;
        this.administratorId = builder.administratorId;
        this.memberStatus = builder.memberStatus;
        this.invitedAt = builder.invitedAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String email() {
        return this.email;
    }

    @Deprecated
    public final String masterId() {
        return this.masterId;
    }

    public final String administratorId() {
        return this.administratorId;
    }

    public final String memberStatus() {
        return this.memberStatus;
    }

    public final Instant invitedAt() {
        return this.invitedAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.administratorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.masterId(), other.masterId()) && Objects.equals(this.administratorId(), other.administratorId()) && Objects.equals(this.memberStatus(), other.memberStatus()) && Objects.equals(this.invitedAt(), other.invitedAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"Member").add("AccountId", (Object)this.accountId()).add("Email", (Object)this.email()).add("MasterId", (Object)this.masterId()).add("AdministratorId", (Object)this.administratorId()).add("MemberStatus", (Object)this.memberStatus()).add("InvitedAt", (Object)this.invitedAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "MasterId": {
                return Optional.ofNullable(clazz.cast(this.masterId()));
            }
            case "AdministratorId": {
                return Optional.ofNullable(clazz.cast(this.administratorId()));
            }
            case "MemberStatus": {
                return Optional.ofNullable(clazz.cast(this.memberStatus()));
            }
            case "InvitedAt": {
                return Optional.ofNullable(clazz.cast(this.invitedAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String email;
        private String masterId;
        private String administratorId;
        private String memberStatus;
        private Instant invitedAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            this.accountId(model.accountId);
            this.email(model.email);
            this.masterId(model.masterId);
            this.administratorId(model.administratorId);
            this.memberStatus(model.memberStatus);
            this.invitedAt(model.invitedAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        @Transient
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        @Deprecated
        public final String getMasterId() {
            return this.masterId;
        }

        @Deprecated
        public final void setMasterId(String masterId) {
            this.masterId = masterId;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder masterId(String masterId) {
            this.masterId = masterId;
            return this;
        }

        public final String getAdministratorId() {
            return this.administratorId;
        }

        public final void setAdministratorId(String administratorId) {
            this.administratorId = administratorId;
        }

        @Override
        @Transient
        public final Builder administratorId(String administratorId) {
            this.administratorId = administratorId;
            return this;
        }

        public final String getMemberStatus() {
            return this.memberStatus;
        }

        public final void setMemberStatus(String memberStatus) {
            this.memberStatus = memberStatus;
        }

        @Override
        @Transient
        public final Builder memberStatus(String memberStatus) {
            this.memberStatus = memberStatus;
            return this;
        }

        public final Instant getInvitedAt() {
            return this.invitedAt;
        }

        public final void setInvitedAt(Instant invitedAt) {
            this.invitedAt = invitedAt;
        }

        @Override
        @Transient
        public final Builder invitedAt(Instant invitedAt) {
            this.invitedAt = invitedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Member build() {
            return new Member(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Member> {
        public Builder accountId(String var1);

        public Builder email(String var1);

        @Deprecated
        public Builder masterId(String var1);

        public Builder administratorId(String var1);

        public Builder memberStatus(String var1);

        public Builder invitedAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

