/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.NetworkHeader;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkPathComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkPathComponent> {
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentId").getter(NetworkPathComponent.getter(NetworkPathComponent::componentId)).setter(NetworkPathComponent.setter(Builder::componentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentId").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentType").getter(NetworkPathComponent.getter(NetworkPathComponent::componentType)).setter(NetworkPathComponent.setter(Builder::componentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentType").build()}).build();
    private static final SdkField<NetworkHeader> EGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Egress").getter(NetworkPathComponent.getter(NetworkPathComponent::egress)).setter(NetworkPathComponent.setter(Builder::egress)).constructor(NetworkHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Egress").build()}).build();
    private static final SdkField<NetworkHeader> INGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ingress").getter(NetworkPathComponent.getter(NetworkPathComponent::ingress)).setter(NetworkPathComponent.setter(Builder::ingress)).constructor(NetworkHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ingress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ID_FIELD, COMPONENT_TYPE_FIELD, EGRESS_FIELD, INGRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentId;
    private final String componentType;
    private final NetworkHeader egress;
    private final NetworkHeader ingress;

    private NetworkPathComponent(BuilderImpl builder) {
        this.componentId = builder.componentId;
        this.componentType = builder.componentType;
        this.egress = builder.egress;
        this.ingress = builder.ingress;
    }

    public final String componentId() {
        return this.componentId;
    }

    public final String componentType() {
        return this.componentType;
    }

    public final NetworkHeader egress() {
        return this.egress;
    }

    public final NetworkHeader ingress() {
        return this.ingress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.egress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkPathComponent)) {
            return false;
        }
        NetworkPathComponent other = (NetworkPathComponent)obj;
        return Objects.equals(this.componentId(), other.componentId()) && Objects.equals(this.componentType(), other.componentType()) && Objects.equals(this.egress(), other.egress()) && Objects.equals(this.ingress(), other.ingress());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkPathComponent").add("ComponentId", (Object)this.componentId()).add("ComponentType", (Object)this.componentType()).add("Egress", (Object)this.egress()).add("Ingress", (Object)this.ingress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComponentId": {
                return Optional.ofNullable(clazz.cast(this.componentId()));
            }
            case "ComponentType": {
                return Optional.ofNullable(clazz.cast(this.componentType()));
            }
            case "Egress": {
                return Optional.ofNullable(clazz.cast(this.egress()));
            }
            case "Ingress": {
                return Optional.ofNullable(clazz.cast(this.ingress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkPathComponent, T> g) {
        return obj -> g.apply((NetworkPathComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentId;
        private String componentType;
        private NetworkHeader egress;
        private NetworkHeader ingress;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkPathComponent model) {
            this.componentId(model.componentId);
            this.componentType(model.componentType);
            this.egress(model.egress);
            this.ingress(model.ingress);
        }

        public final String getComponentId() {
            return this.componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        @Transient
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final String getComponentType() {
            return this.componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        @Transient
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public final NetworkHeader.Builder getEgress() {
            return this.egress != null ? this.egress.toBuilder() : null;
        }

        public final void setEgress(NetworkHeader.BuilderImpl egress) {
            this.egress = egress != null ? egress.build() : null;
        }

        @Override
        @Transient
        public final Builder egress(NetworkHeader egress) {
            this.egress = egress;
            return this;
        }

        public final NetworkHeader.Builder getIngress() {
            return this.ingress != null ? this.ingress.toBuilder() : null;
        }

        public final void setIngress(NetworkHeader.BuilderImpl ingress) {
            this.ingress = ingress != null ? ingress.build() : null;
        }

        @Override
        @Transient
        public final Builder ingress(NetworkHeader ingress) {
            this.ingress = ingress;
            return this;
        }

        public NetworkPathComponent build() {
            return new NetworkPathComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkPathComponent> {
        public Builder componentId(String var1);

        public Builder componentType(String var1);

        public Builder egress(NetworkHeader var1);

        default public Builder egress(Consumer<NetworkHeader.Builder> egress) {
            return this.egress((NetworkHeader)((NetworkHeader.Builder)NetworkHeader.builder().applyMutation(egress)).build());
        }

        public Builder ingress(NetworkHeader var1);

        default public Builder ingress(Consumer<NetworkHeader.Builder> ingress) {
            return this.ingress((NetworkHeader)((NetworkHeader.Builder)NetworkHeader.builder().applyMutation(ingress)).build());
        }
    }
}

