/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactTargetInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactTargetInfo> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(ContactTargetInfo.getter(ContactTargetInfo::contactId)).setter(ContactTargetInfo.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<Boolean> IS_ESSENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsEssential").getter(ContactTargetInfo.getter(ContactTargetInfo::isEssential)).setter(ContactTargetInfo.setter(Builder::isEssential)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEssential").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, IS_ESSENTIAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String contactId;
    private final Boolean isEssential;

    private ContactTargetInfo(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.isEssential = builder.isEssential;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final Boolean isEssential() {
        return this.isEssential;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEssential());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactTargetInfo)) {
            return false;
        }
        ContactTargetInfo other = (ContactTargetInfo)obj;
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.isEssential(), other.isEssential());
    }

    public final String toString() {
        return ToString.builder((String)"ContactTargetInfo").add("ContactId", (Object)this.contactId()).add("IsEssential", (Object)this.isEssential()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "IsEssential": {
                return Optional.ofNullable(clazz.cast(this.isEssential()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactTargetInfo, T> g) {
        return obj -> g.apply((ContactTargetInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactId;
        private Boolean isEssential;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactTargetInfo model) {
            this.contactId(model.contactId);
            this.isEssential(model.isEssential);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        @Transient
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final Boolean getIsEssential() {
            return this.isEssential;
        }

        public final void setIsEssential(Boolean isEssential) {
            this.isEssential = isEssential;
        }

        @Override
        @Transient
        public final Builder isEssential(Boolean isEssential) {
            this.isEssential = isEssential;
            return this;
        }

        public ContactTargetInfo build() {
            return new ContactTargetInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactTargetInfo> {
        public Builder contactId(String var1);

        public Builder isEssential(Boolean var1);
    }
}

