/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse;

public class ListAccountAssignmentDeletionStatusIterable
implements SdkIterable<ListAccountAssignmentDeletionStatusResponse> {
    private final SsoAdminClient client;
    private final ListAccountAssignmentDeletionStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountAssignmentDeletionStatusIterable(SsoAdminClient client, ListAccountAssignmentDeletionStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccountAssignmentDeletionStatusResponseFetcher();
    }

    public Iterator<ListAccountAssignmentDeletionStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountAssignmentOperationStatusMetadata> accountAssignmentsDeletionStatus() {
        Function<ListAccountAssignmentDeletionStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountAssignmentsDeletionStatus() != null) {
                return response.accountAssignmentsDeletionStatus().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountAssignmentDeletionStatusResponseFetcher
    implements SyncPageFetcher<ListAccountAssignmentDeletionStatusResponse> {
        private ListAccountAssignmentDeletionStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountAssignmentDeletionStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountAssignmentDeletionStatusResponse nextPage(ListAccountAssignmentDeletionStatusResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAssignmentDeletionStatusIterable.this.client.listAccountAssignmentDeletionStatus(ListAccountAssignmentDeletionStatusIterable.this.firstRequest);
            }
            return ListAccountAssignmentDeletionStatusIterable.this.client.listAccountAssignmentDeletionStatus((ListAccountAssignmentDeletionStatusRequest)((Object)ListAccountAssignmentDeletionStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

