/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationInfo;
import software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationInfoListCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFileSystemAssociationsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeFileSystemAssociationsResponse> {
    private static final SdkField<List<FileSystemAssociationInfo>> FILE_SYSTEM_ASSOCIATION_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileSystemAssociationInfoList").getter(DescribeFileSystemAssociationsResponse.getter(DescribeFileSystemAssociationsResponse::fileSystemAssociationInfoList)).setter(DescribeFileSystemAssociationsResponse.setter(Builder::fileSystemAssociationInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileSystemAssociationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ASSOCIATION_INFO_LIST_FIELD));
    private final List<FileSystemAssociationInfo> fileSystemAssociationInfoList;

    private DescribeFileSystemAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.fileSystemAssociationInfoList = builder.fileSystemAssociationInfoList;
    }

    public final boolean hasFileSystemAssociationInfoList() {
        return this.fileSystemAssociationInfoList != null && !(this.fileSystemAssociationInfoList instanceof SdkAutoConstructList);
    }

    public final List<FileSystemAssociationInfo> fileSystemAssociationInfoList() {
        return this.fileSystemAssociationInfoList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemAssociationInfoList() ? this.fileSystemAssociationInfoList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemAssociationsResponse)) {
            return false;
        }
        DescribeFileSystemAssociationsResponse other = (DescribeFileSystemAssociationsResponse)((Object)obj);
        return this.hasFileSystemAssociationInfoList() == other.hasFileSystemAssociationInfoList() && Objects.equals(this.fileSystemAssociationInfoList(), other.fileSystemAssociationInfoList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFileSystemAssociationsResponse").add("FileSystemAssociationInfoList", this.hasFileSystemAssociationInfoList() ? this.fileSystemAssociationInfoList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemAssociationInfoList": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAssociationInfoList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFileSystemAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeFileSystemAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<FileSystemAssociationInfo> fileSystemAssociationInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemAssociationsResponse model) {
            super(model);
            this.fileSystemAssociationInfoList(model.fileSystemAssociationInfoList);
        }

        public final List<FileSystemAssociationInfo.Builder> getFileSystemAssociationInfoList() {
            List<FileSystemAssociationInfo.Builder> result = FileSystemAssociationInfoListCopier.copyToBuilder(this.fileSystemAssociationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemAssociationInfoList(Collection<FileSystemAssociationInfo.BuilderImpl> fileSystemAssociationInfoList) {
            this.fileSystemAssociationInfoList = FileSystemAssociationInfoListCopier.copyFromBuilder(fileSystemAssociationInfoList);
        }

        @Override
        @Transient
        public final Builder fileSystemAssociationInfoList(Collection<FileSystemAssociationInfo> fileSystemAssociationInfoList) {
            this.fileSystemAssociationInfoList = FileSystemAssociationInfoListCopier.copy(fileSystemAssociationInfoList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fileSystemAssociationInfoList(FileSystemAssociationInfo ... fileSystemAssociationInfoList) {
            this.fileSystemAssociationInfoList(Arrays.asList(fileSystemAssociationInfoList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fileSystemAssociationInfoList(Consumer<FileSystemAssociationInfo.Builder> ... fileSystemAssociationInfoList) {
            this.fileSystemAssociationInfoList(Stream.of(fileSystemAssociationInfoList).map(c -> (FileSystemAssociationInfo)((FileSystemAssociationInfo.Builder)FileSystemAssociationInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeFileSystemAssociationsResponse build() {
            return new DescribeFileSystemAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFileSystemAssociationsResponse> {
        public Builder fileSystemAssociationInfoList(Collection<FileSystemAssociationInfo> var1);

        public Builder fileSystemAssociationInfoList(FileSystemAssociationInfo ... var1);

        public Builder fileSystemAssociationInfoList(Consumer<FileSystemAssociationInfo.Builder> ... var1);
    }
}

