/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.FileShareARNListCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSmbFileSharesRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, DescribeSmbFileSharesRequest> {
    private static final SdkField<List<String>> FILE_SHARE_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileShareARNList").getter(DescribeSmbFileSharesRequest.getter(DescribeSmbFileSharesRequest::fileShareARNList)).setter(DescribeSmbFileSharesRequest.setter(Builder::fileShareARNList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARNList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_LIST_FIELD));
    private final List<String> fileShareARNList;

    private DescribeSmbFileSharesRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARNList = builder.fileShareARNList;
    }

    public final boolean hasFileShareARNList() {
        return this.fileShareARNList != null && !(this.fileShareARNList instanceof SdkAutoConstructList);
    }

    public final List<String> fileShareARNList() {
        return this.fileShareARNList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileShareARNList() ? this.fileShareARNList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSmbFileSharesRequest)) {
            return false;
        }
        DescribeSmbFileSharesRequest other = (DescribeSmbFileSharesRequest)((Object)obj);
        return this.hasFileShareARNList() == other.hasFileShareARNList() && Objects.equals(this.fileShareARNList(), other.fileShareARNList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSmbFileSharesRequest").add("FileShareARNList", this.hasFileShareARNList() ? this.fileShareARNList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileShareARNList": {
                return Optional.ofNullable(clazz.cast(this.fileShareARNList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSmbFileSharesRequest, T> g) {
        return obj -> g.apply((DescribeSmbFileSharesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private List<String> fileShareARNList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSmbFileSharesRequest model) {
            super(model);
            this.fileShareARNList(model.fileShareARNList);
        }

        public final Collection<String> getFileShareARNList() {
            if (this.fileShareARNList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fileShareARNList;
        }

        public final void setFileShareARNList(Collection<String> fileShareARNList) {
            this.fileShareARNList = FileShareARNListCopier.copy(fileShareARNList);
        }

        @Override
        @Transient
        public final Builder fileShareARNList(Collection<String> fileShareARNList) {
            this.fileShareARNList = FileShareARNListCopier.copy(fileShareARNList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fileShareARNList(String ... fileShareARNList) {
            this.fileShareARNList(Arrays.asList(fileShareARNList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSmbFileSharesRequest build() {
            return new DescribeSmbFileSharesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSmbFileSharesRequest> {
        public Builder fileShareARNList(Collection<String> var1);

        public Builder fileShareARNList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

