/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.CacheAttributes;
import software.amazon.awssdk.services.storagegateway.model.CaseSensitivity;
import software.amazon.awssdk.services.storagegateway.model.ObjectACL;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.services.storagegateway.model.UserListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SMBFileShareInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SMBFileShareInfo> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareARN").getter(SMBFileShareInfo.getter(SMBFileShareInfo::fileShareARN)).setter(SMBFileShareInfo.setter(Builder::fileShareARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()}).build();
    private static final SdkField<String> FILE_SHARE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareId").getter(SMBFileShareInfo.getter(SMBFileShareInfo::fileShareId)).setter(SMBFileShareInfo.setter(Builder::fileShareId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareId").build()}).build();
    private static final SdkField<String> FILE_SHARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareStatus").getter(SMBFileShareInfo.getter(SMBFileShareInfo::fileShareStatus)).setter(SMBFileShareInfo.setter(Builder::fileShareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareStatus").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(SMBFileShareInfo.getter(SMBFileShareInfo::gatewayARN)).setter(SMBFileShareInfo.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KMSEncrypted").getter(SMBFileShareInfo.getter(SMBFileShareInfo::kmsEncrypted)).setter(SMBFileShareInfo.setter(Builder::kmsEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKey").getter(SMBFileShareInfo.getter(SMBFileShareInfo::kmsKey)).setter(SMBFileShareInfo.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(SMBFileShareInfo.getter(SMBFileShareInfo::path)).setter(SMBFileShareInfo.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(SMBFileShareInfo.getter(SMBFileShareInfo::role)).setter(SMBFileShareInfo.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationARN").getter(SMBFileShareInfo.getter(SMBFileShareInfo::locationARN)).setter(SMBFileShareInfo.setter(Builder::locationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()}).build();
    private static final SdkField<String> DEFAULT_STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultStorageClass").getter(SMBFileShareInfo.getter(SMBFileShareInfo::defaultStorageClass)).setter(SMBFileShareInfo.setter(Builder::defaultStorageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageClass").build()}).build();
    private static final SdkField<String> OBJECT_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectACL").getter(SMBFileShareInfo.getter(SMBFileShareInfo::objectACLAsString)).setter(SMBFileShareInfo.setter(Builder::objectACL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectACL").build()}).build();
    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReadOnly").getter(SMBFileShareInfo.getter(SMBFileShareInfo::readOnly)).setter(SMBFileShareInfo.setter(Builder::readOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()}).build();
    private static final SdkField<Boolean> GUESS_MIME_TYPE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("GuessMIMETypeEnabled").getter(SMBFileShareInfo.getter(SMBFileShareInfo::guessMIMETypeEnabled)).setter(SMBFileShareInfo.setter(Builder::guessMIMETypeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuessMIMETypeEnabled").build()}).build();
    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequesterPays").getter(SMBFileShareInfo.getter(SMBFileShareInfo::requesterPays)).setter(SMBFileShareInfo.setter(Builder::requesterPays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").build()}).build();
    private static final SdkField<Boolean> SMBACL_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SMBACLEnabled").getter(SMBFileShareInfo.getter(SMBFileShareInfo::smbaclEnabled)).setter(SMBFileShareInfo.setter(Builder::smbaclEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBACLEnabled").build()}).build();
    private static final SdkField<Boolean> ACCESS_BASED_ENUMERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AccessBasedEnumeration").getter(SMBFileShareInfo.getter(SMBFileShareInfo::accessBasedEnumeration)).setter(SMBFileShareInfo.setter(Builder::accessBasedEnumeration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessBasedEnumeration").build()}).build();
    private static final SdkField<List<String>> ADMIN_USER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdminUserList").getter(SMBFileShareInfo.getter(SMBFileShareInfo::adminUserList)).setter(SMBFileShareInfo.setter(Builder::adminUserList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminUserList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VALID_USER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidUserList").getter(SMBFileShareInfo.getter(SMBFileShareInfo::validUserList)).setter(SMBFileShareInfo.setter(Builder::validUserList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUserList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INVALID_USER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InvalidUserList").getter(SMBFileShareInfo.getter(SMBFileShareInfo::invalidUserList)).setter(SMBFileShareInfo.setter(Builder::invalidUserList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidUserList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditDestinationARN").getter(SMBFileShareInfo.getter(SMBFileShareInfo::auditDestinationARN)).setter(SMBFileShareInfo.setter(Builder::auditDestinationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build()}).build();
    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Authentication").getter(SMBFileShareInfo.getter(SMBFileShareInfo::authentication)).setter(SMBFileShareInfo.setter(Builder::authentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()}).build();
    private static final SdkField<String> CASE_SENSITIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaseSensitivity").getter(SMBFileShareInfo.getter(SMBFileShareInfo::caseSensitivityAsString)).setter(SMBFileShareInfo.setter(Builder::caseSensitivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseSensitivity").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SMBFileShareInfo.getter(SMBFileShareInfo::tags)).setter(SMBFileShareInfo.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FILE_SHARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareName").getter(SMBFileShareInfo.getter(SMBFileShareInfo::fileShareName)).setter(SMBFileShareInfo.setter(Builder::fileShareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareName").build()}).build();
    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheAttributes").getter(SMBFileShareInfo.getter(SMBFileShareInfo::cacheAttributes)).setter(SMBFileShareInfo.setter(Builder::cacheAttributes)).constructor(CacheAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()}).build();
    private static final SdkField<String> NOTIFICATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationPolicy").getter(SMBFileShareInfo.getter(SMBFileShareInfo::notificationPolicy)).setter(SMBFileShareInfo.setter(Builder::notificationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationPolicy").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCEndpointDNSName").getter(SMBFileShareInfo.getter(SMBFileShareInfo::vpcEndpointDNSName)).setter(SMBFileShareInfo.setter(Builder::vpcEndpointDNSName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCEndpointDNSName").build()}).build();
    private static final SdkField<String> BUCKET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketRegion").getter(SMBFileShareInfo.getter(SMBFileShareInfo::bucketRegion)).setter(SMBFileShareInfo.setter(Builder::bucketRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketRegion").build()}).build();
    private static final SdkField<Boolean> OPLOCKS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OplocksEnabled").getter(SMBFileShareInfo.getter(SMBFileShareInfo::oplocksEnabled)).setter(SMBFileShareInfo.setter(Builder::oplocksEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OplocksEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD, FILE_SHARE_ID_FIELD, FILE_SHARE_STATUS_FIELD, GATEWAY_ARN_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, PATH_FIELD, ROLE_FIELD, LOCATION_ARN_FIELD, DEFAULT_STORAGE_CLASS_FIELD, OBJECT_ACL_FIELD, READ_ONLY_FIELD, GUESS_MIME_TYPE_ENABLED_FIELD, REQUESTER_PAYS_FIELD, SMBACL_ENABLED_FIELD, ACCESS_BASED_ENUMERATION_FIELD, ADMIN_USER_LIST_FIELD, VALID_USER_LIST_FIELD, INVALID_USER_LIST_FIELD, AUDIT_DESTINATION_ARN_FIELD, AUTHENTICATION_FIELD, CASE_SENSITIVITY_FIELD, TAGS_FIELD, FILE_SHARE_NAME_FIELD, CACHE_ATTRIBUTES_FIELD, NOTIFICATION_POLICY_FIELD, VPC_ENDPOINT_DNS_NAME_FIELD, BUCKET_REGION_FIELD, OPLOCKS_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileShareARN;
    private final String fileShareId;
    private final String fileShareStatus;
    private final String gatewayARN;
    private final Boolean kmsEncrypted;
    private final String kmsKey;
    private final String path;
    private final String role;
    private final String locationARN;
    private final String defaultStorageClass;
    private final String objectACL;
    private final Boolean readOnly;
    private final Boolean guessMIMETypeEnabled;
    private final Boolean requesterPays;
    private final Boolean smbaclEnabled;
    private final Boolean accessBasedEnumeration;
    private final List<String> adminUserList;
    private final List<String> validUserList;
    private final List<String> invalidUserList;
    private final String auditDestinationARN;
    private final String authentication;
    private final String caseSensitivity;
    private final List<Tag> tags;
    private final String fileShareName;
    private final CacheAttributes cacheAttributes;
    private final String notificationPolicy;
    private final String vpcEndpointDNSName;
    private final String bucketRegion;
    private final Boolean oplocksEnabled;

    private SMBFileShareInfo(BuilderImpl builder) {
        this.fileShareARN = builder.fileShareARN;
        this.fileShareId = builder.fileShareId;
        this.fileShareStatus = builder.fileShareStatus;
        this.gatewayARN = builder.gatewayARN;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.path = builder.path;
        this.role = builder.role;
        this.locationARN = builder.locationARN;
        this.defaultStorageClass = builder.defaultStorageClass;
        this.objectACL = builder.objectACL;
        this.readOnly = builder.readOnly;
        this.guessMIMETypeEnabled = builder.guessMIMETypeEnabled;
        this.requesterPays = builder.requesterPays;
        this.smbaclEnabled = builder.smbaclEnabled;
        this.accessBasedEnumeration = builder.accessBasedEnumeration;
        this.adminUserList = builder.adminUserList;
        this.validUserList = builder.validUserList;
        this.invalidUserList = builder.invalidUserList;
        this.auditDestinationARN = builder.auditDestinationARN;
        this.authentication = builder.authentication;
        this.caseSensitivity = builder.caseSensitivity;
        this.tags = builder.tags;
        this.fileShareName = builder.fileShareName;
        this.cacheAttributes = builder.cacheAttributes;
        this.notificationPolicy = builder.notificationPolicy;
        this.vpcEndpointDNSName = builder.vpcEndpointDNSName;
        this.bucketRegion = builder.bucketRegion;
        this.oplocksEnabled = builder.oplocksEnabled;
    }

    public final String fileShareARN() {
        return this.fileShareARN;
    }

    public final String fileShareId() {
        return this.fileShareId;
    }

    public final String fileShareStatus() {
        return this.fileShareStatus;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final Boolean kmsEncrypted() {
        return this.kmsEncrypted;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String path() {
        return this.path;
    }

    public final String role() {
        return this.role;
    }

    public final String locationARN() {
        return this.locationARN;
    }

    public final String defaultStorageClass() {
        return this.defaultStorageClass;
    }

    public final ObjectACL objectACL() {
        return ObjectACL.fromValue(this.objectACL);
    }

    public final String objectACLAsString() {
        return this.objectACL;
    }

    public final Boolean readOnly() {
        return this.readOnly;
    }

    public final Boolean guessMIMETypeEnabled() {
        return this.guessMIMETypeEnabled;
    }

    public final Boolean requesterPays() {
        return this.requesterPays;
    }

    public final Boolean smbaclEnabled() {
        return this.smbaclEnabled;
    }

    public final Boolean accessBasedEnumeration() {
        return this.accessBasedEnumeration;
    }

    public final boolean hasAdminUserList() {
        return this.adminUserList != null && !(this.adminUserList instanceof SdkAutoConstructList);
    }

    public final List<String> adminUserList() {
        return this.adminUserList;
    }

    public final boolean hasValidUserList() {
        return this.validUserList != null && !(this.validUserList instanceof SdkAutoConstructList);
    }

    public final List<String> validUserList() {
        return this.validUserList;
    }

    public final boolean hasInvalidUserList() {
        return this.invalidUserList != null && !(this.invalidUserList instanceof SdkAutoConstructList);
    }

    public final List<String> invalidUserList() {
        return this.invalidUserList;
    }

    public final String auditDestinationARN() {
        return this.auditDestinationARN;
    }

    public final String authentication() {
        return this.authentication;
    }

    public final CaseSensitivity caseSensitivity() {
        return CaseSensitivity.fromValue(this.caseSensitivity);
    }

    public final String caseSensitivityAsString() {
        return this.caseSensitivity;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String fileShareName() {
        return this.fileShareName;
    }

    public final CacheAttributes cacheAttributes() {
        return this.cacheAttributes;
    }

    public final String notificationPolicy() {
        return this.notificationPolicy;
    }

    public final String vpcEndpointDNSName() {
        return this.vpcEndpointDNSName;
    }

    public final String bucketRegion() {
        return this.bucketRegion;
    }

    public final Boolean oplocksEnabled() {
        return this.oplocksEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultStorageClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.guessMIMETypeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(this.smbaclEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessBasedEnumeration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdminUserList() ? this.adminUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidUserList() ? this.validUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvalidUserList() ? this.invalidUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.auditDestinationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseSensitivityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointDNSName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.oplocksEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMBFileShareInfo)) {
            return false;
        }
        SMBFileShareInfo other = (SMBFileShareInfo)obj;
        return Objects.equals(this.fileShareARN(), other.fileShareARN()) && Objects.equals(this.fileShareId(), other.fileShareId()) && Objects.equals(this.fileShareStatus(), other.fileShareStatus()) && Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.locationARN(), other.locationARN()) && Objects.equals(this.defaultStorageClass(), other.defaultStorageClass()) && Objects.equals(this.objectACLAsString(), other.objectACLAsString()) && Objects.equals(this.readOnly(), other.readOnly()) && Objects.equals(this.guessMIMETypeEnabled(), other.guessMIMETypeEnabled()) && Objects.equals(this.requesterPays(), other.requesterPays()) && Objects.equals(this.smbaclEnabled(), other.smbaclEnabled()) && Objects.equals(this.accessBasedEnumeration(), other.accessBasedEnumeration()) && this.hasAdminUserList() == other.hasAdminUserList() && Objects.equals(this.adminUserList(), other.adminUserList()) && this.hasValidUserList() == other.hasValidUserList() && Objects.equals(this.validUserList(), other.validUserList()) && this.hasInvalidUserList() == other.hasInvalidUserList() && Objects.equals(this.invalidUserList(), other.invalidUserList()) && Objects.equals(this.auditDestinationARN(), other.auditDestinationARN()) && Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.caseSensitivityAsString(), other.caseSensitivityAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.fileShareName(), other.fileShareName()) && Objects.equals(this.cacheAttributes(), other.cacheAttributes()) && Objects.equals(this.notificationPolicy(), other.notificationPolicy()) && Objects.equals(this.vpcEndpointDNSName(), other.vpcEndpointDNSName()) && Objects.equals(this.bucketRegion(), other.bucketRegion()) && Objects.equals(this.oplocksEnabled(), other.oplocksEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"SMBFileShareInfo").add("FileShareARN", (Object)this.fileShareARN()).add("FileShareId", (Object)this.fileShareId()).add("FileShareStatus", (Object)this.fileShareStatus()).add("GatewayARN", (Object)this.gatewayARN()).add("KMSEncrypted", (Object)this.kmsEncrypted()).add("KMSKey", (Object)this.kmsKey()).add("Path", (Object)this.path()).add("Role", (Object)this.role()).add("LocationARN", (Object)this.locationARN()).add("DefaultStorageClass", (Object)this.defaultStorageClass()).add("ObjectACL", (Object)this.objectACLAsString()).add("ReadOnly", (Object)this.readOnly()).add("GuessMIMETypeEnabled", (Object)this.guessMIMETypeEnabled()).add("RequesterPays", (Object)this.requesterPays()).add("SMBACLEnabled", (Object)this.smbaclEnabled()).add("AccessBasedEnumeration", (Object)this.accessBasedEnumeration()).add("AdminUserList", this.hasAdminUserList() ? this.adminUserList() : null).add("ValidUserList", this.hasValidUserList() ? this.validUserList() : null).add("InvalidUserList", this.hasInvalidUserList() ? this.invalidUserList() : null).add("AuditDestinationARN", (Object)this.auditDestinationARN()).add("Authentication", (Object)this.authentication()).add("CaseSensitivity", (Object)this.caseSensitivityAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("FileShareName", (Object)this.fileShareName()).add("CacheAttributes", (Object)this.cacheAttributes()).add("NotificationPolicy", (Object)this.notificationPolicy()).add("VPCEndpointDNSName", (Object)this.vpcEndpointDNSName()).add("BucketRegion", (Object)this.bucketRegion()).add("OplocksEnabled", (Object)this.oplocksEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileShareARN": {
                return Optional.ofNullable(clazz.cast(this.fileShareARN()));
            }
            case "FileShareId": {
                return Optional.ofNullable(clazz.cast(this.fileShareId()));
            }
            case "FileShareStatus": {
                return Optional.ofNullable(clazz.cast(this.fileShareStatus()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "KMSEncrypted": {
                return Optional.ofNullable(clazz.cast(this.kmsEncrypted()));
            }
            case "KMSKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "LocationARN": {
                return Optional.ofNullable(clazz.cast(this.locationARN()));
            }
            case "DefaultStorageClass": {
                return Optional.ofNullable(clazz.cast(this.defaultStorageClass()));
            }
            case "ObjectACL": {
                return Optional.ofNullable(clazz.cast(this.objectACLAsString()));
            }
            case "ReadOnly": {
                return Optional.ofNullable(clazz.cast(this.readOnly()));
            }
            case "GuessMIMETypeEnabled": {
                return Optional.ofNullable(clazz.cast(this.guessMIMETypeEnabled()));
            }
            case "RequesterPays": {
                return Optional.ofNullable(clazz.cast(this.requesterPays()));
            }
            case "SMBACLEnabled": {
                return Optional.ofNullable(clazz.cast(this.smbaclEnabled()));
            }
            case "AccessBasedEnumeration": {
                return Optional.ofNullable(clazz.cast(this.accessBasedEnumeration()));
            }
            case "AdminUserList": {
                return Optional.ofNullable(clazz.cast(this.adminUserList()));
            }
            case "ValidUserList": {
                return Optional.ofNullable(clazz.cast(this.validUserList()));
            }
            case "InvalidUserList": {
                return Optional.ofNullable(clazz.cast(this.invalidUserList()));
            }
            case "AuditDestinationARN": {
                return Optional.ofNullable(clazz.cast(this.auditDestinationARN()));
            }
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "CaseSensitivity": {
                return Optional.ofNullable(clazz.cast(this.caseSensitivityAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "FileShareName": {
                return Optional.ofNullable(clazz.cast(this.fileShareName()));
            }
            case "CacheAttributes": {
                return Optional.ofNullable(clazz.cast(this.cacheAttributes()));
            }
            case "NotificationPolicy": {
                return Optional.ofNullable(clazz.cast(this.notificationPolicy()));
            }
            case "VPCEndpointDNSName": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointDNSName()));
            }
            case "BucketRegion": {
                return Optional.ofNullable(clazz.cast(this.bucketRegion()));
            }
            case "OplocksEnabled": {
                return Optional.ofNullable(clazz.cast(this.oplocksEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SMBFileShareInfo, T> g) {
        return obj -> g.apply((SMBFileShareInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileShareARN;
        private String fileShareId;
        private String fileShareStatus;
        private String gatewayARN;
        private Boolean kmsEncrypted;
        private String kmsKey;
        private String path;
        private String role;
        private String locationARN;
        private String defaultStorageClass;
        private String objectACL;
        private Boolean readOnly;
        private Boolean guessMIMETypeEnabled;
        private Boolean requesterPays;
        private Boolean smbaclEnabled;
        private Boolean accessBasedEnumeration;
        private List<String> adminUserList = DefaultSdkAutoConstructList.getInstance();
        private List<String> validUserList = DefaultSdkAutoConstructList.getInstance();
        private List<String> invalidUserList = DefaultSdkAutoConstructList.getInstance();
        private String auditDestinationARN;
        private String authentication;
        private String caseSensitivity;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String fileShareName;
        private CacheAttributes cacheAttributes;
        private String notificationPolicy;
        private String vpcEndpointDNSName;
        private String bucketRegion;
        private Boolean oplocksEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SMBFileShareInfo model) {
            this.fileShareARN(model.fileShareARN);
            this.fileShareId(model.fileShareId);
            this.fileShareStatus(model.fileShareStatus);
            this.gatewayARN(model.gatewayARN);
            this.kmsEncrypted(model.kmsEncrypted);
            this.kmsKey(model.kmsKey);
            this.path(model.path);
            this.role(model.role);
            this.locationARN(model.locationARN);
            this.defaultStorageClass(model.defaultStorageClass);
            this.objectACL(model.objectACL);
            this.readOnly(model.readOnly);
            this.guessMIMETypeEnabled(model.guessMIMETypeEnabled);
            this.requesterPays(model.requesterPays);
            this.smbaclEnabled(model.smbaclEnabled);
            this.accessBasedEnumeration(model.accessBasedEnumeration);
            this.adminUserList(model.adminUserList);
            this.validUserList(model.validUserList);
            this.invalidUserList(model.invalidUserList);
            this.auditDestinationARN(model.auditDestinationARN);
            this.authentication(model.authentication);
            this.caseSensitivity(model.caseSensitivity);
            this.tags(model.tags);
            this.fileShareName(model.fileShareName);
            this.cacheAttributes(model.cacheAttributes);
            this.notificationPolicy(model.notificationPolicy);
            this.vpcEndpointDNSName(model.vpcEndpointDNSName);
            this.bucketRegion(model.bucketRegion);
            this.oplocksEnabled(model.oplocksEnabled);
        }

        public final String getFileShareARN() {
            return this.fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        @Transient
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final String getFileShareId() {
            return this.fileShareId;
        }

        public final void setFileShareId(String fileShareId) {
            this.fileShareId = fileShareId;
        }

        @Override
        @Transient
        public final Builder fileShareId(String fileShareId) {
            this.fileShareId = fileShareId;
            return this;
        }

        public final String getFileShareStatus() {
            return this.fileShareStatus;
        }

        public final void setFileShareStatus(String fileShareStatus) {
            this.fileShareStatus = fileShareStatus;
        }

        @Override
        @Transient
        public final Builder fileShareStatus(String fileShareStatus) {
            this.fileShareStatus = fileShareStatus;
            return this;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        @Transient
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Boolean getKmsEncrypted() {
            return this.kmsEncrypted;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        @Override
        @Transient
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        @Transient
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        @Transient
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getLocationARN() {
            return this.locationARN;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        @Override
        @Transient
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final String getDefaultStorageClass() {
            return this.defaultStorageClass;
        }

        public final void setDefaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
        }

        @Override
        @Transient
        public final Builder defaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
            return this;
        }

        public final String getObjectACL() {
            return this.objectACL;
        }

        public final void setObjectACL(String objectACL) {
            this.objectACL = objectACL;
        }

        @Override
        @Transient
        public final Builder objectACL(String objectACL) {
            this.objectACL = objectACL;
            return this;
        }

        @Override
        @Transient
        public final Builder objectACL(ObjectACL objectACL) {
            this.objectACL(objectACL == null ? null : objectACL.toString());
            return this;
        }

        public final Boolean getReadOnly() {
            return this.readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        @Transient
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final Boolean getGuessMIMETypeEnabled() {
            return this.guessMIMETypeEnabled;
        }

        public final void setGuessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
        }

        @Override
        @Transient
        public final Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
            return this;
        }

        public final Boolean getRequesterPays() {
            return this.requesterPays;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        @Override
        @Transient
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final Boolean getSmbaclEnabled() {
            return this.smbaclEnabled;
        }

        public final void setSmbaclEnabled(Boolean smbaclEnabled) {
            this.smbaclEnabled = smbaclEnabled;
        }

        @Override
        @Transient
        public final Builder smbaclEnabled(Boolean smbaclEnabled) {
            this.smbaclEnabled = smbaclEnabled;
            return this;
        }

        public final Boolean getAccessBasedEnumeration() {
            return this.accessBasedEnumeration;
        }

        public final void setAccessBasedEnumeration(Boolean accessBasedEnumeration) {
            this.accessBasedEnumeration = accessBasedEnumeration;
        }

        @Override
        @Transient
        public final Builder accessBasedEnumeration(Boolean accessBasedEnumeration) {
            this.accessBasedEnumeration = accessBasedEnumeration;
            return this;
        }

        public final Collection<String> getAdminUserList() {
            if (this.adminUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.adminUserList;
        }

        public final void setAdminUserList(Collection<String> adminUserList) {
            this.adminUserList = UserListCopier.copy(adminUserList);
        }

        @Override
        @Transient
        public final Builder adminUserList(Collection<String> adminUserList) {
            this.adminUserList = UserListCopier.copy(adminUserList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder adminUserList(String ... adminUserList) {
            this.adminUserList(Arrays.asList(adminUserList));
            return this;
        }

        public final Collection<String> getValidUserList() {
            if (this.validUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validUserList;
        }

        public final void setValidUserList(Collection<String> validUserList) {
            this.validUserList = UserListCopier.copy(validUserList);
        }

        @Override
        @Transient
        public final Builder validUserList(Collection<String> validUserList) {
            this.validUserList = UserListCopier.copy(validUserList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder validUserList(String ... validUserList) {
            this.validUserList(Arrays.asList(validUserList));
            return this;
        }

        public final Collection<String> getInvalidUserList() {
            if (this.invalidUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.invalidUserList;
        }

        public final void setInvalidUserList(Collection<String> invalidUserList) {
            this.invalidUserList = UserListCopier.copy(invalidUserList);
        }

        @Override
        @Transient
        public final Builder invalidUserList(Collection<String> invalidUserList) {
            this.invalidUserList = UserListCopier.copy(invalidUserList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder invalidUserList(String ... invalidUserList) {
            this.invalidUserList(Arrays.asList(invalidUserList));
            return this;
        }

        public final String getAuditDestinationARN() {
            return this.auditDestinationARN;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        @Override
        @Transient
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        public final String getAuthentication() {
            return this.authentication;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        @Override
        @Transient
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getCaseSensitivity() {
            return this.caseSensitivity;
        }

        public final void setCaseSensitivity(String caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
        }

        @Override
        @Transient
        public final Builder caseSensitivity(String caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
            return this;
        }

        @Override
        @Transient
        public final Builder caseSensitivity(CaseSensitivity caseSensitivity) {
            this.caseSensitivity(caseSensitivity == null ? null : caseSensitivity.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFileShareName() {
            return this.fileShareName;
        }

        public final void setFileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
        }

        @Override
        @Transient
        public final Builder fileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
            return this;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return this.cacheAttributes != null ? this.cacheAttributes.toBuilder() : null;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final String getNotificationPolicy() {
            return this.notificationPolicy;
        }

        public final void setNotificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
        }

        @Override
        @Transient
        public final Builder notificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
            return this;
        }

        public final String getVpcEndpointDNSName() {
            return this.vpcEndpointDNSName;
        }

        public final void setVpcEndpointDNSName(String vpcEndpointDNSName) {
            this.vpcEndpointDNSName = vpcEndpointDNSName;
        }

        @Override
        @Transient
        public final Builder vpcEndpointDNSName(String vpcEndpointDNSName) {
            this.vpcEndpointDNSName = vpcEndpointDNSName;
            return this;
        }

        public final String getBucketRegion() {
            return this.bucketRegion;
        }

        public final void setBucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
        }

        @Override
        @Transient
        public final Builder bucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
            return this;
        }

        public final Boolean getOplocksEnabled() {
            return this.oplocksEnabled;
        }

        public final void setOplocksEnabled(Boolean oplocksEnabled) {
            this.oplocksEnabled = oplocksEnabled;
        }

        @Override
        @Transient
        public final Builder oplocksEnabled(Boolean oplocksEnabled) {
            this.oplocksEnabled = oplocksEnabled;
            return this;
        }

        public SMBFileShareInfo build() {
            return new SMBFileShareInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SMBFileShareInfo> {
        public Builder fileShareARN(String var1);

        public Builder fileShareId(String var1);

        public Builder fileShareStatus(String var1);

        public Builder gatewayARN(String var1);

        public Builder kmsEncrypted(Boolean var1);

        public Builder kmsKey(String var1);

        public Builder path(String var1);

        public Builder role(String var1);

        public Builder locationARN(String var1);

        public Builder defaultStorageClass(String var1);

        public Builder objectACL(String var1);

        public Builder objectACL(ObjectACL var1);

        public Builder readOnly(Boolean var1);

        public Builder guessMIMETypeEnabled(Boolean var1);

        public Builder requesterPays(Boolean var1);

        public Builder smbaclEnabled(Boolean var1);

        public Builder accessBasedEnumeration(Boolean var1);

        public Builder adminUserList(Collection<String> var1);

        public Builder adminUserList(String ... var1);

        public Builder validUserList(Collection<String> var1);

        public Builder validUserList(String ... var1);

        public Builder invalidUserList(Collection<String> var1);

        public Builder invalidUserList(String ... var1);

        public Builder auditDestinationARN(String var1);

        public Builder authentication(String var1);

        public Builder caseSensitivity(String var1);

        public Builder caseSensitivity(CaseSensitivity var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder fileShareName(String var1);

        public Builder cacheAttributes(CacheAttributes var1);

        default public Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return this.cacheAttributes((CacheAttributes)((CacheAttributes.Builder)CacheAttributes.builder().applyMutation(cacheAttributes)).build());
        }

        public Builder notificationPolicy(String var1);

        public Builder vpcEndpointDNSName(String var1);

        public Builder bucketRegion(String var1);

        public Builder oplocksEnabled(Boolean var1);
    }
}

