/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamquery.model.ScheduledQuery;
import software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryListCopier;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScheduledQueriesResponse
extends TimestreamQueryResponse
implements ToCopyableBuilder<Builder, ListScheduledQueriesResponse> {
    private static final SdkField<List<ScheduledQuery>> SCHEDULED_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduledQueries").getter(ListScheduledQueriesResponse.getter(ListScheduledQueriesResponse::scheduledQueries)).setter(ListScheduledQueriesResponse.setter(Builder::scheduledQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListScheduledQueriesResponse.getter(ListScheduledQueriesResponse::nextToken)).setter(ListScheduledQueriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_QUERIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ScheduledQuery> scheduledQueries;
    private final String nextToken;

    private ListScheduledQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledQueries = builder.scheduledQueries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScheduledQueries() {
        return this.scheduledQueries != null && !(this.scheduledQueries instanceof SdkAutoConstructList);
    }

    public final List<ScheduledQuery> scheduledQueries() {
        return this.scheduledQueries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledQueries() ? this.scheduledQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScheduledQueriesResponse)) {
            return false;
        }
        ListScheduledQueriesResponse other = (ListScheduledQueriesResponse)((Object)obj);
        return this.hasScheduledQueries() == other.hasScheduledQueries() && Objects.equals(this.scheduledQueries(), other.scheduledQueries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListScheduledQueriesResponse").add("ScheduledQueries", this.hasScheduledQueries() ? this.scheduledQueries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledQueries": {
                return Optional.ofNullable(clazz.cast(this.scheduledQueries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScheduledQueriesResponse, T> g) {
        return obj -> g.apply((ListScheduledQueriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamQueryResponse.BuilderImpl
    implements Builder {
        private List<ScheduledQuery> scheduledQueries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScheduledQueriesResponse model) {
            super(model);
            this.scheduledQueries(model.scheduledQueries);
            this.nextToken(model.nextToken);
        }

        public final List<ScheduledQuery.Builder> getScheduledQueries() {
            List<ScheduledQuery.Builder> result = ScheduledQueryListCopier.copyToBuilder(this.scheduledQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledQueries(Collection<ScheduledQuery.BuilderImpl> scheduledQueries) {
            this.scheduledQueries = ScheduledQueryListCopier.copyFromBuilder(scheduledQueries);
        }

        @Override
        @Transient
        public final Builder scheduledQueries(Collection<ScheduledQuery> scheduledQueries) {
            this.scheduledQueries = ScheduledQueryListCopier.copy(scheduledQueries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scheduledQueries(ScheduledQuery ... scheduledQueries) {
            this.scheduledQueries(Arrays.asList(scheduledQueries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scheduledQueries(Consumer<ScheduledQuery.Builder> ... scheduledQueries) {
            this.scheduledQueries(Stream.of(scheduledQueries).map(c -> (ScheduledQuery)((ScheduledQuery.Builder)ScheduledQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListScheduledQueriesResponse build() {
            return new ListScheduledQueriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TimestreamQueryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScheduledQueriesResponse> {
        public Builder scheduledQueries(Collection<ScheduledQuery> var1);

        public Builder scheduledQueries(ScheduledQuery ... var1);

        public Builder scheduledQueries(Consumer<ScheduledQuery.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

