/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.translate.model.Directionality;
import software.amazon.awssdk.services.translate.model.TerminologyDataFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminologyData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TerminologyData> {
    private static final SdkField<SdkBytes> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("File").getter(TerminologyData.getter(TerminologyData::file)).setter(TerminologyData.setter(Builder::file)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("File").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(TerminologyData.getter(TerminologyData::formatAsString)).setter(TerminologyData.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<String> DIRECTIONALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Directionality").getter(TerminologyData.getter(TerminologyData::directionalityAsString)).setter(TerminologyData.setter(Builder::directionality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Directionality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD, FORMAT_FIELD, DIRECTIONALITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes file;
    private final String format;
    private final String directionality;

    private TerminologyData(BuilderImpl builder) {
        this.file = builder.file;
        this.format = builder.format;
        this.directionality = builder.directionality;
    }

    public final SdkBytes file() {
        return this.file;
    }

    public final TerminologyDataFormat format() {
        return TerminologyDataFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final Directionality directionality() {
        return Directionality.fromValue(this.directionality);
    }

    public final String directionalityAsString() {
        return this.directionality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.directionalityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminologyData)) {
            return false;
        }
        TerminologyData other = (TerminologyData)obj;
        return Objects.equals(this.file(), other.file()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.directionalityAsString(), other.directionalityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TerminologyData").add("File", (Object)(this.file() == null ? null : "*** Sensitive Data Redacted ***")).add("Format", (Object)this.formatAsString()).add("Directionality", (Object)this.directionalityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "File": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "Directionality": {
                return Optional.ofNullable(clazz.cast(this.directionalityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminologyData, T> g) {
        return obj -> g.apply((TerminologyData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes file;
        private String format;
        private String directionality;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminologyData model) {
            this.file(model.file);
            this.format(model.format);
            this.directionality(model.directionality);
        }

        public final ByteBuffer getFile() {
            return this.file == null ? null : this.file.asByteBuffer();
        }

        public final void setFile(ByteBuffer file) {
            this.file(file == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)file));
        }

        @Override
        @Transient
        public final Builder file(SdkBytes file) {
            this.file = file;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @Transient
        public final Builder format(TerminologyDataFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getDirectionality() {
            return this.directionality;
        }

        public final void setDirectionality(String directionality) {
            this.directionality = directionality;
        }

        @Override
        @Transient
        public final Builder directionality(String directionality) {
            this.directionality = directionality;
            return this;
        }

        @Override
        @Transient
        public final Builder directionality(Directionality directionality) {
            this.directionality(directionality == null ? null : directionality.toString());
            return this;
        }

        public TerminologyData build() {
            return new TerminologyData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TerminologyData> {
        public Builder file(SdkBytes var1);

        public Builder format(String var1);

        public Builder format(TerminologyDataFormat var1);

        public Builder directionality(String var1);

        public Builder directionality(Directionality var1);
    }
}

