/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.IpRuleItem;
import software.amazon.awssdk.services.workspaces.model.IpRuleListCopier;
import software.amazon.awssdk.services.workspaces.model.Tag;
import software.amazon.awssdk.services.workspaces.model.TagListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIpGroupRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, CreateIpGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(CreateIpGroupRequest.getter(CreateIpGroupRequest::groupName)).setter(CreateIpGroupRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> GROUP_DESC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupDesc").getter(CreateIpGroupRequest.getter(CreateIpGroupRequest::groupDesc)).setter(CreateIpGroupRequest.setter(Builder::groupDesc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDesc").build()}).build();
    private static final SdkField<List<IpRuleItem>> USER_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserRules").getter(CreateIpGroupRequest.getter(CreateIpGroupRequest::userRules)).setter(CreateIpGroupRequest.setter(Builder::userRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpRuleItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateIpGroupRequest.getter(CreateIpGroupRequest::tags)).setter(CreateIpGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, GROUP_DESC_FIELD, USER_RULES_FIELD, TAGS_FIELD));
    private final String groupName;
    private final String groupDesc;
    private final List<IpRuleItem> userRules;
    private final List<Tag> tags;

    private CreateIpGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.groupDesc = builder.groupDesc;
        this.userRules = builder.userRules;
        this.tags = builder.tags;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String groupDesc() {
        return this.groupDesc;
    }

    public final boolean hasUserRules() {
        return this.userRules != null && !(this.userRules instanceof SdkAutoConstructList);
    }

    public final List<IpRuleItem> userRules() {
        return this.userRules;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupDesc());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserRules() ? this.userRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpGroupRequest)) {
            return false;
        }
        CreateIpGroupRequest other = (CreateIpGroupRequest)((Object)obj);
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.groupDesc(), other.groupDesc()) && this.hasUserRules() == other.hasUserRules() && Objects.equals(this.userRules(), other.userRules()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIpGroupRequest").add("GroupName", (Object)this.groupName()).add("GroupDesc", (Object)this.groupDesc()).add("UserRules", this.hasUserRules() ? this.userRules() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "GroupDesc": {
                return Optional.ofNullable(clazz.cast(this.groupDesc()));
            }
            case "UserRules": {
                return Optional.ofNullable(clazz.cast(this.userRules()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpGroupRequest, T> g) {
        return obj -> g.apply((CreateIpGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String groupName;
        private String groupDesc;
        private List<IpRuleItem> userRules = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpGroupRequest model) {
            super(model);
            this.groupName(model.groupName);
            this.groupDesc(model.groupDesc);
            this.userRules(model.userRules);
            this.tags(model.tags);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Transient
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroupDesc() {
            return this.groupDesc;
        }

        public final void setGroupDesc(String groupDesc) {
            this.groupDesc = groupDesc;
        }

        @Override
        @Transient
        public final Builder groupDesc(String groupDesc) {
            this.groupDesc = groupDesc;
            return this;
        }

        public final List<IpRuleItem.Builder> getUserRules() {
            List<IpRuleItem.Builder> result = IpRuleListCopier.copyToBuilder(this.userRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserRules(Collection<IpRuleItem.BuilderImpl> userRules) {
            this.userRules = IpRuleListCopier.copyFromBuilder(userRules);
        }

        @Override
        @Transient
        public final Builder userRules(Collection<IpRuleItem> userRules) {
            this.userRules = IpRuleListCopier.copy(userRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userRules(IpRuleItem ... userRules) {
            this.userRules(Arrays.asList(userRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userRules(Consumer<IpRuleItem.Builder> ... userRules) {
            this.userRules(Stream.of(userRules).map(c -> (IpRuleItem)((IpRuleItem.Builder)IpRuleItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpGroupRequest build() {
            return new CreateIpGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIpGroupRequest> {
        public Builder groupName(String var1);

        public Builder groupDesc(String var1);

        public Builder userRules(Collection<IpRuleItem> var1);

        public Builder userRules(IpRuleItem ... var1);

        public Builder userRules(Consumer<IpRuleItem.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

