/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.cache.redis.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.boot.cache.redis.RedisFactory;
import com.ovopark.boot.cache.redis.service.BootRedisService;
import com.ovopark.boot.cache.utils.SerializeUtil;
import com.ovopark.boot.kit.json.JacksonKit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

@Component
public class BootRedisServiceImpl
implements BootRedisService {
    @Autowired
    private JedisPool jedisPool;
    private static ShardedJedisPool shardedJedisPool = null;
    public static Logger log = LoggerFactory.getLogger(RedisFactory.class);
    private static int default_db = 0;

    public synchronized Jedis getJedis() {
        try {
            if (this.jedisPool != null) {
                Jedis resource = this.jedisPool.getResource();
                return resource;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis\u7f13\u5b58\u83b7\u53d6Jedis\u5b9e\u4f8b \u51fa\u9519\uff01", (Throwable)e);
            return null;
        }
    }

    public static ShardedJedis getShardedJedis() {
        try {
            if (shardedJedisPool != null) {
                ShardedJedis resource = shardedJedisPool.getResource();
                return resource;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis\u7f13\u5b58\u83b7\u53d6shardedJedis\u5b9e\u4f8b \u51fa\u9519\uff01", (Throwable)e);
            return null;
        }
    }

    public void closeResource(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    public void closeResource(ShardedJedis shardedJedis) {
        if (shardedJedis != null) {
            shardedJedis.close();
        }
    }

    @Override
    public boolean set(Object key, String value) {
        return this.set(key, value, default_db);
    }

    @Override
    public boolean set(Object key, String value, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                jedis.set((String)key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            return false;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public boolean set(Object key, String value, String nxxx, String expx, long time) {
        return this.set(key, value, nxxx, expx, time, default_db);
    }

    @Override
    public boolean set(Object key, String value, String nxxx, String expx, long time, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                jedis.set((String)key, value, nxxx, expx, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            return false;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public <T> boolean setPoJo(Object key, Object pojo) {
        return this.setPoJo(key, pojo, default_db);
    }

    @Override
    public <T> boolean setPoJo(Object key, Object pojo, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = JacksonKit.toJSon((Object)pojo);
                jedis.set((String)key, json);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            return false;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public <T> boolean setPoJo(Object key, Object pojo, String nxxx, String expx, long time) {
        return this.setPoJo(key, pojo, nxxx, expx, time, default_db);
    }

    @Override
    public <T> boolean setPoJo(Object key, Object pojo, String nxxx, String expx, long time, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = JacksonKit.toJSon((Object)pojo);
                jedis.set((String)key, json, nxxx, expx, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            return false;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public <T> boolean setlist(Object key, List<T> list) {
        return this.setlist(key, list, default_db);
    }

    @Override
    public <T> boolean setlist(Object key, List<T> list, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = JacksonKit.toJSon(list);
                jedis.set((String)key, json);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011 \u51fa\u9519\uff01", (Throwable)e);
            return false;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public <T> boolean setlist(Object key, List<T> list, String nxxx, String expx, long time) {
        return this.setlist(key, list, nxxx, expx, time, default_db);
    }

    @Override
    public <T> boolean setlist(Object key, List<T> list, String nxxx, String expx, long time, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = JacksonKit.toJSon(list);
                jedis.set((String)key, json, nxxx, expx, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011 \u51fa\u9519\uff01", (Throwable)e);
            return false;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Object get(Object key) {
        return this.get(key, default_db);
    }

    @Override
    public Object get(Object key, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String string = jedis.get((String)key);
                return string;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u83b7\u53d6key\u503c\u3010" + key + "\u3011 \u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public <T> T get(Object key, Class<T> clazz) {
        return this.get(key, clazz, default_db);
    }

    @Override
    public <T> T get(Object key, Class<T> clazz, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Object object = JacksonKit.readValue((String)JacksonKit.toJSon((Object)jedis.get((String)key)), (TypeReference)new TypeReference<T>(){});
                return (T)object;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u83b7\u53d6key\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public <T> List<T> getList(Object key) {
        return this.getList(key, default_db);
    }

    @Override
    public <T> List<T> getList(Object key, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                List list = (List)JacksonKit.readValue((String)JacksonKit.toJSon((Object)jedis.get((String)key)), (TypeReference)new TypeReference<List<T>>(){});
                return list;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u83b7\u53d6key\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Long del(Object key) {
        return this.del(key, default_db);
    }

    @Override
    public Long del(Object key, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.del((String)key);
                return l;
            }
            Long l = 0L;
            return l;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u5220\u9664key\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            Long l = 0L;
            return l;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Set<String> keys(String pattern) {
        return this.keys(pattern, default_db);
    }

    @Override
    public Set<String> keys(String pattern, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Set set = jedis.keys(pattern);
                return set;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u83b7\u53d6pattern\u503c\u3010" + pattern + "\u3011 \u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public boolean setExpire(Object key, String value, int time) {
        return this.setExpire(key, value, time, default_db);
    }

    @Override
    public boolean setExpire(Object key, String value, int time, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                jedis.set((String)key, value);
                jedis.expire((String)key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            return false;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public <T> boolean setPoJoExpire(Object key, Object pojo, int time) {
        return this.setPoJoExpire(key, pojo, time, default_db);
    }

    @Override
    public <T> boolean setPoJoExpire(Object key, Object pojo, int time, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = JacksonKit.toJSon((Object)pojo);
                jedis.set((String)key, json);
                jedis.expire((String)key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            return false;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public <T> boolean setlistExpire(Object key, List<T> list, int time) {
        return this.setPoJoExpire(key, list, time, default_db);
    }

    @Override
    public <T> boolean setlistExpire(Object key, List<T> list, int time, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String json = JacksonKit.toJSon(list);
                jedis.set((String)key, json);
                jedis.expire((String)key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u7f13\u5b58\u8bbe\u7f6ekey\u503c \u3010" + key + "\u3011 \u51fa\u9519\uff01", (Throwable)e);
            return false;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Long ttl(Object key) {
        return this.ttl(key, default_db);
    }

    @Override
    public Long ttl(Object key, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.ttl((String)key);
                return l;
            }
            Long l = 0L;
            return l;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u83b7\u53d6key\u503c \u3010" + key + "\u3011\u5269\u4f59\u751f\u5b58\u65f6\u95f4\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            Long l = 0L;
            return l;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Long zadd(String key, double score, String member) {
        return this.zadd(key, score, member, default_db);
    }

    @Override
    public Long zadd(String key, double score, String member, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.zadd(key, score, member);
                return l;
            }
            Long l = 0L;
            return l;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u83b7\u53d6key\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            Long l = 0L;
            return l;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Set<String> zrevrange(String key, int start, int end) {
        return this.zrevrange(key, start, end, default_db);
    }

    @Override
    public Set<String> zrevrange(String key, int start, int end, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Set set = jedis.zrevrange(key, (long)start, (long)end);
                return set;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u83b7\u53d6key\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Set<String> zrange(String key, int start, int end) {
        return this.zrange(key, start, end, default_db);
    }

    @Override
    public Set<String> zrange(String key, int start, int end, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Set set = jedis.zrange(key, (long)start, (long)end);
                return set;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u83b7\u53d6key\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Double zscore(String key, String member) {
        return this.zscore(key, member, default_db);
    }

    @Override
    public Double zscore(String key, String member, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Double d = jedis.zscore(key, member);
                return d;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u83b7\u53d6key\u503c \u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Long zrem(String key, String member) {
        return this.zrem(key, member, default_db);
    }

    @Override
    public Long zrem(String key, String member, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.zrem(key, new String[]{member});
                return l;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "\u5220\u9664key\u503c \u3010" + key + "\u3011,member\u503c\u3010" + member + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Long zcard(String key) {
        return this.zcard(key, default_db);
    }

    @Override
    public Long zcard(String key, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.zcard(key);
                return l;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "scard\u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Long hset(String key, String field, String value) {
        return this.hset(key, field, value, default_db);
    }

    @Override
    public Long hset(String key, String field, String value, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.hset(key, field, value);
                return l;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "hset\u3010" + key + "\u3011,field\u3010" + field + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public String hget(String key, String field) {
        return this.hget(key, field, default_db);
    }

    @Override
    public String hget(String key, String field, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                String string = jedis.hget(key, field);
                return string;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "hget\u3010" + key + "\u3011,field\u3010" + field + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Long hdel(String key, String field) {
        return this.hdel(key, field, default_db);
    }

    @Override
    public Long hdel(String key, String field, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.hdel(key, new String[]{field});
                return l;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "hdel\u3010" + key + "\u3011,field\u3010" + field + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Map<String, String> hgetall(String key) {
        return this.hgetall(key, default_db);
    }

    @Override
    public Map<String, String> hgetall(String key, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Map map = jedis.hgetAll(key);
                return map;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "hgetall\u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public byte[] getObject(String key, int index) {
        Jedis jedis = this.getJedis();
        Object obj = null;
        try {
            if (jedis != null) {
                byte[] data;
                if (index != default_db) {
                    jedis.select(index);
                }
                byte[] byArray = data = jedis.get(key.getBytes());
                return byArray;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "getObject\u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public boolean setObject(String key, Object obj, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                jedis.set(key.getBytes(), SerializeUtil.serialize(obj));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "setObject\u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return false;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public Long dbsize(int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                Long l = jedis.dbSize();
                return l;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "dbsize\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }

    @Override
    public List<String> scan(String key) {
        return this.scan(key, default_db);
    }

    @Override
    public List<String> scan(String key, int index) {
        Jedis jedis = this.getJedis();
        try {
            if (jedis != null) {
                if (index != default_db) {
                    jedis.select(index);
                }
                ScanParams scanParams = new ScanParams();
                scanParams.match(String.valueOf(key) + "*");
                scanParams.count(Integer.valueOf(1000));
                ScanResult result = jedis.scan("0", scanParams);
                List list = result.getResult();
                return list;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Redis db" + index + "scan\u3010" + key + "\u3011\u51fa\u9519\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        finally {
            this.closeResource(jedis);
        }
    }
}

