package com.ovopark.boot.cache;

import java.util.List;

/**
 * 
    * @ClassName: Cache
    * @Description: TODO(缓存接口)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年8月11日 上午11:17:31
 */
public interface Cache {
	/**
	    * @Title: put
	    * @Description: TODO(设置缓存)
	    * @param  cacheName	缓存名称
	    * @param  key	key值
	    * @param  value    参数
	    * @return void    返回类型
	    * @throws
	 */
	void put(String cacheName, Object key, Object value);
	/**
	 * 
	    * @Title: get
	    * @Description: TODO(获取某个缓存)
	    * @param @param cacheName	缓存名称
	    * @param @param key	key值
	    * @param @return    参数
	    * @return T    返回类型
	    * @throws
	 */
	<T> T get(String cacheName, Object key);
	/**
	    * @Title: remove
	    * @Description: TODO(删除某个缓存)
	    * @param @param cacheName	缓存名称
	    * @param @param key  key值
	    * @return void    返回类型
	    * @throws
	 */
	void remove(String cacheName, Object key);
	/**
	    * @Title: removeAll
	    * @Description: TODO(删除所有缓存)
	    * @param @param cacheName    缓存名称
	    * @return void    返回类型
	    * @throws
	 */
	void removeAll(String cacheName);
	/**
	 * 
	    * @Title: getKeys
	    * @Description: TODO(根据缓存名称获取所有key)
	    * @param @param cacheName
	    * @param @return    参数
	    * @return List    返回类型
	    * @throws
	 */
	@SuppressWarnings("rawtypes")
	List getKeys(String cacheName);
}
