package com.ovopark.boot.cache.config;

import com.ovopark.boot.cache.Cache;
import com.ovopark.boot.cache.Redis;
import com.ovopark.boot.cache.ehCache.EhcacheFactory;
import com.ovopark.boot.cache.redis.RedisFactory;

public class Config {
	private static final Config me = new Config();
	private Config() {
	}
	public static Config me() {
		return me;
	}
	
	private Cache defaultCacheFactory;
	
	private Redis redisCacheFactory;
	/**
	 * 默认缓存工厂类
	 */
	public Cache getDefaultCacheFactory() {
		defaultCacheFactory=EhcacheFactory.createEhcache();
		return defaultCacheFactory;
	}
	public void setDefaultCacheFactory(Cache defaultCacheFactory) {
		this.defaultCacheFactory = defaultCacheFactory;
	}
	public Redis getRedisCacheFactory() {
		redisCacheFactory=RedisFactory.createRedis();
		return redisCacheFactory;
	}
	public void setRedisCacheFactory(Redis redisCacheFactory) {
		this.redisCacheFactory = redisCacheFactory;
	}
	
	
}
