package com.ovopark.boot.cache.ehCache;


import java.util.List;

import com.ovopark.boot.cache.Cache;
import com.ovopark.boot.cache.config.Config;

/**
 * 
    * @ClassName: CoCoEhCacheKit
    * @Description: TODO(EhCache 工具类)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年8月28日 上午10:26:29
 */
public class CoCoEhCacheKit {
	private static Cache  cacheFactory= Config.me().getDefaultCacheFactory();
	public static void put(String cacheName, Object key, Object value) {
		cacheFactory.put(cacheName, key, value);
	}
	
	public static <T> T get(String cacheName, Object key) {
		return cacheFactory.get(cacheName, key);
	}
	
	
	public static void remove(String cacheName, Object key) {
		cacheFactory.remove(cacheName, key);
	}
	
	public static void removeAll(String cacheName) {
		cacheFactory.removeAll(cacheName);
	}
	
	@SuppressWarnings("rawtypes")
	public static List  getKeys(String cacheName){
		return cacheFactory.getKeys(cacheName);
	}
}
