package com.ovopark.boot.cache.redis.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ovopark.boot.cache.redis.RedisFactory;
import com.ovopark.boot.cache.redis.service.BootRedisService;
import com.ovopark.boot.cache.utils.SerializeUtil;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
@Component
public class BootRedisServiceImpl implements BootRedisService{
	@Autowired
	private JedisPool jedisPool;
	//分布式
	private static ShardedJedisPool shardedJedisPool = null;
	
	public static Logger log = LoggerFactory.getLogger(RedisFactory.class);
	//默认数据库
	private static int default_db=0;
	/**
	 * 
	    * @Title: getJedis
	    * @Description: TODO(获取Jedis实例)
	    * @param @return    参数
	    * @return Jedis    返回类型
	    * @throws
	 */
    public synchronized  Jedis getJedis() {
        try {
            if (jedisPool != null) {
                Jedis resource = jedisPool.getResource();
                return resource;
            } else {
                return null;
            }
        } catch (Exception e) {
            log.error("Redis缓存获取Jedis实例 出错！", e);
            return null;
        }
    }
    /**
     * 
        * @Title: getShardedJedis
        * @Description: TODO(获取shardedJedis实例)
        * @param @return    参数
        * @return ShardedJedis    返回类型
        * @throws
     */
    public static ShardedJedis getShardedJedis() {
        try {
            if (shardedJedisPool != null) {
                ShardedJedis resource = shardedJedisPool.getResource();
                return resource;
            } else {
                return null;
            }
        } catch (Exception e) {
            log.error("Redis缓存获取shardedJedis实例 出错！", e);
            return null;
        }
    }
    
    /**
        * @Title: closeResource
        * @Description: TODO(释放jedis资源)
        * @param @param jedis    参数
        * @return void    返回类型
        * @throws
     */
    public  void closeResource(final Jedis jedis) {
        if (jedis != null) {
            jedisPool.returnResource(jedis);
        }
    }

   /**
       * @Title: closeResource
       * @Description: TODO( 释放shardedJedis资源)
       * @param @param shardedJedis    参数
       * @return void    返回类型
       * @throws
    */
    public  void closeResource(final ShardedJedis shardedJedis) {
        if (shardedJedis != null) {
        	shardedJedisPool.returnResource(shardedJedis);
        }
    }
    
    @Override
	public boolean  set(Object key, String value) {
    	 return set(key,value,default_db);
	}
	@Override
	public boolean set(Object key, String value, int index) {
		Jedis jedis = getJedis();
		try {
            if(jedis != null){
            	if(index!=default_db)
            		jedis.select(index);
                jedis.set((String)key, value);
            }
            return true;
        } catch (Exception e) {
            log.error("Redis db"+index+"缓存设置key值 【"+key+"】出错！", e);
            return false;
        } finally {
            closeResource(jedis);
        }
	}
	
	@Override
	public boolean set(Object key, String value,String nxxx, String expx,  long time) {
		return set(key,value,nxxx,expx,time,default_db);
	}
	@Override
	public boolean set(Object key, String value, String nxxx, String expx, long time, int index) {
		Jedis jedis = getJedis();
		try {
            if(jedis != null){
               	if(index!=default_db)
               		jedis.select(index);
                jedis.set((String)key, value,nxxx,expx,time);
            }
            return true;
        } catch (Exception e) {
            log.error("Redis db"+index+"缓存设置key值 【"+key+"】出错！", e);
            return false;
        } finally {
            closeResource(jedis);
        }
	}
	
	@Override
	public <T> boolean  setPoJo(Object key,  Object pojo) {
		return setPoJo(key,pojo,default_db);
	}
	@Override
	public <T> boolean setPoJo(Object key, Object pojo, int index) {
		Jedis jedis = getJedis();
		try {
            if(jedis != null){
             	if(index!=default_db)
               		jedis.select(index);
            	String json=new Gson().toJson(pojo);
                jedis.set((String)key, json);
            }
            return true;
        } catch (Exception e) {
            log.error("Redis db"+index+"缓存设置key值 【"+key+"】出错！", e);
            return false;
        } finally {
            closeResource(jedis);
        }
	}
	
	@Override
	public <T> boolean setPoJo(Object key,Object pojo,String nxxx, String expx,  long time) {
		return setPoJo(key,pojo,nxxx,expx,time,default_db);
	}
	@Override
	public <T> boolean setPoJo(Object key, Object pojo, String nxxx, String expx, long time, int index) {
		Jedis jedis = getJedis();
		try {
            if(jedis != null){
            	if(index!=default_db)
               		jedis.select(index);
            	String json=new Gson().toJson(pojo);
                jedis.set((String)key, json,nxxx,expx,time);
            }
            return true;
        } catch (Exception e) {
            log.error("Redis db"+index+"缓存设置key值 【"+key+"】出错！", e);
            return false;
        } finally {
            closeResource(jedis);
        }
	}
	
	@Override
	public <T> boolean  setlist(Object key, List<T> list) {
		return setlist(key,list,default_db);
	}
	@Override
	public <T> boolean setlist(Object key, List<T> list, int index) {
		Jedis jedis = getJedis();
		try {
            if(jedis != null){
            	if(index!=default_db)
               		jedis.select(index);
        		String json=new Gson().toJson(list);
                jedis.set((String)key, json);
            }
            return true;
        } catch (Exception e) {
            log.error("Redis db"+index+"缓存设置key值 【"+key+"】 出错！", e);
            return false;
        } finally {
            closeResource(jedis);
        }
	}
	
	@Override
	public <T> boolean setlist(Object key, List<T> list,String nxxx, String expx,  long time) {
		return setlist(key,list,nxxx,expx,time,default_db);
	}
	@Override
	public <T> boolean setlist(Object key, List<T> list, String nxxx, String expx, long time, int index) {
		Jedis jedis = getJedis();
		try {
            if(jedis != null){
             	if(index!=default_db)
               		jedis.select(index);
        		String json=new Gson().toJson(list);
                jedis.set((String)key, json,nxxx,expx,time);
            }
            return true;
        } catch (Exception e) {
            log.error("Redis db"+index+"缓存设置key值 【"+key+"】 出错！", e);
            return false;
        } finally {
            closeResource(jedis);
        }
	}
	
	@Override
	public Object get(Object key) {
		return get(key,default_db);
	}
	@Override
	public Object get(Object key, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
            	if(index!=default_db)
               		jedis.select(index);
            	 return jedis.get((String)key);
            } else {
                return null;
            }
        } catch (Exception e) {
        	log.error("Redis db"+index+"缓存获取key值【"+key+"】 出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	
	@Override
	public <T> T get(Object key, Class<T> clazz) {
		return get(key,clazz,default_db);
	}
	@Override
	public <T> T get(Object key, Class<T> clazz, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
               	if(index!=default_db)
               		jedis.select(index);
            	 return (T) new Gson().fromJson(jedis.get((String)key), clazz);
            } else {
                return null;
            }
        } catch (Exception e) {
        	log.error("Redis db"+index+"缓存获取key值 【"+key+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	
	@Override
	public  <T> List<T> getList(Object key) {
		return getList(key,default_db);
	}
	@SuppressWarnings("unchecked")
	@Override
	public <T> List<T> getList(Object key, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
               	if(index!=default_db)
               		jedis.select(index);
            	 return (List<T>)new Gson().fromJson(jedis.get((String)key), new TypeToken<List<T>>() {}.getType());
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"缓存获取key值 【"+key+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	
	@Override
	public Long del(Object key) {
		return del(key,default_db);
	}
	@Override
	public Long del(Object key, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return jedis.del((String)key) ; 
            } else {
                return 0L;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"缓存删除key值 【"+key+"】出错！", e);
            e.printStackTrace();
            return 0L;
        } finally {
        	closeResource(jedis);
        }
	}
	@Override
	public Set<String> keys(String pattern) {
		return keys(pattern,default_db);
	}
	@Override
	public Set<String> keys(String pattern, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
            	if(index!=default_db)
               		jedis.select(index);
            	 return  jedis.keys(pattern);
            } else {
                return null;
            }
        } catch (Exception e) {
        	log.error("Redis db"+index+"缓存获取pattern值【"+pattern+"】 出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	
	@Override
	public boolean setExpire(Object key, String value, int time) {
		return setExpire(key,value,time,default_db);
	}
	@Override
	public boolean setExpire(Object key, String value, int time, int index) {
		Jedis jedis = getJedis();
		try {
            if(jedis != null){
            	if(index!=default_db)
            		jedis.select(index);
                jedis.set((String)key, value);
                jedis.expire((String)key, time);
            }
            return true;
        } catch (Exception e) {
            log.error("Redis db"+index+"缓存设置key值 【"+key+"】出错！", e);
            return false;
        } finally {
            closeResource(jedis);
        }
	}
	@Override
	public <T> boolean setPoJoExpire(Object key, Object pojo, int time) {
		return setPoJoExpire(key,pojo,time,default_db);
	}
	@Override
	public <T> boolean setPoJoExpire(Object key, Object pojo, int time, int index) {
		Jedis jedis = getJedis();
		try {
            if(jedis != null){
             	if(index!=default_db)
               		jedis.select(index);
            	String json=new Gson().toJson(pojo);
                jedis.set((String)key, json);
                jedis.expire((String)key, time);
            }
            return true;
        } catch (Exception e) {
            log.error("Redis db"+index+"缓存设置key值 【"+key+"】出错！", e);
            return false;
        } finally {
            closeResource(jedis);
        }
	}
	@Override
	public <T> boolean setlistExpire(Object key, List<T> list, int time) {
		return  setPoJoExpire(key,list,time,default_db);
	}
	@Override
	public <T> boolean setlistExpire(Object key, List<T> list, int time, int index) {
		Jedis jedis = getJedis();
		try {
            if(jedis != null){
            	if(index!=default_db)
               		jedis.select(index);
        		String json=new Gson().toJson(list);
                jedis.set((String)key, json);
                jedis.expire((String)key, time);
            }
            return true;
        } catch (Exception e) {
            log.error("Redis db"+index+"缓存设置key值 【"+key+"】 出错！", e);
            return false;
        } finally {
            closeResource(jedis);
        }
	}
	@Override
	public Long ttl(Object key) {
		return ttl(key,default_db);
	}
	@Override
	public Long ttl(Object key, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return jedis.ttl((String)key) ; 
            } else {
                return 0L;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"获取key值 【"+key+"】剩余生存时间出错！", e);
            e.printStackTrace();
            return 0L;
        } finally {
        	closeResource(jedis);
        }
	}
	@Override
	public Long zadd(String key, double score, String member) {
		return zadd(key,score,member,default_db);
	}
	@Override
	public Long zadd(String key, double score, String member, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return  jedis.zadd(key, score, member); 
            } else {
                return 0L;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"获取key值 【"+key+"】出错！", e);
            e.printStackTrace();
            return 0L;
        } finally {
        	closeResource(jedis);
        }
		
	}
	@Override
	public Set<String> zrevrange(String key, int start, int end) {
		return zrevrange(key,start,end,default_db);
	}
	@Override
	public Set<String> zrevrange(String key, int start, int end, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return  jedis.zrevrange(key, start, end); 
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"获取key值 【"+key+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	@Override
	public Set<String> zrange(String key, int start, int end) {
		return zrange(key,start,end,default_db);
	}
	@Override
	public Set<String> zrange(String key, int start, int end, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return  jedis.zrange(key, start, end); 
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"获取key值 【"+key+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	@Override
	public Double zscore(String key, String member) {
		return zscore(key,member,default_db);
	}
	@Override
	public Double zscore(String key, String member, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return  jedis.zscore(key, member); 
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"获取key值 【"+key+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	@Override
	public Long zrem(String key, String member) {
		return zrem(key,member,default_db);
	}
	@Override
	public Long zrem(String key, String member, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return  jedis.zrem(key, member); 
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"删除key值 【"+key+"】,member值【"+member+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	@Override
	public Long zcard(String key) {
		return zcard(key,default_db);
	}
	@Override
	public Long zcard(String key, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return  jedis.zcard(key);
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"scard【"+key+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	
	@Override
	public Long hset(String key, String field, String value) {
		return hset(key,field,value,default_db);
	}
	@Override
	public Long hset(String key, String field, String value, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return  jedis.hset(key, field, value);
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"hset【"+key+"】,field【"+field+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	@Override
	public String hget(String key, String field) {
		return hget(key,field,default_db);
	}
	@Override
	public String hget(String key, String field, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return  jedis.hget(key, field);
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"hget【"+key+"】,field【"+field+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	@Override
	public Long hdel(String key, String field) {
		return hdel(key,field,default_db);
	}
	@Override
	public Long hdel(String key, String field, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return  jedis.hdel(key, field);
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"hdel【"+key+"】,field【"+field+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	@Override
	public Map<String, String> hgetall(String key) {
		return hgetall(key,default_db);
	}
	@Override
	public Map<String, String> hgetall(String key, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return  jedis.hgetAll(key);
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"hgetall【"+key+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	
	
	@Override
	public byte[] getObject(String key, int index) {
		Jedis jedis = getJedis();
		Object obj = null;
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
              	
              	byte[] data= jedis.get(key.getBytes());
//	       		if (data != null && data.length > 0) {
//	       			obj = SerializeUtil.unserialize(data);
//	       		}
//            	return  obj;
              	return data;
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"getObject【"+key+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	
	@Override
	public boolean setObject(String key, Object obj, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
              	jedis.set(key.getBytes(), SerializeUtil.serialize(obj));
            	return true;
            } else {
                return false;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"setObject【"+key+"】出错！", e);
            e.printStackTrace();
            return false;
        } finally {
        	closeResource(jedis);
        }
	}
	@Override
	public Long dbsize(int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
            	return  jedis.dbSize();
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"dbsize出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	@Override
	public List<String> scan(String key) {
		return scan(key,default_db);
	}
	@Override
	public List<String> scan(String key, int index) {
		Jedis jedis = getJedis();
        try {
            if (jedis != null) {
              	if(index!=default_db)
               		jedis.select(index);
              	ScanParams scanParams = new ScanParams();
                scanParams.match(key+"*");
                scanParams.count(1000);
              	ScanResult<String> result=jedis.scan("0", scanParams);
            	return result.getResult();
            } else {
                return null;
            }
        } catch (Exception e) {
         	log.error("Redis db"+index+"scan【"+key+"】出错！", e);
            e.printStackTrace();
            return null;
        } finally {
        	closeResource(jedis);
        }
	}
	
	
}
