/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.cache.ehCache;

import com.ovopark.boot.cache.BaseCacheFactory;
import com.ovopark.boot.cache.IDataLoader;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheFactory
extends BaseCacheFactory {
    private static volatile CacheManager cacheManager;
    private static final Logger log;

    public static EhcacheFactory createEhcache() {
        return CoCoEhcache.instance.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheManager getCacheManager() {
        if (cacheManager != null) return cacheManager;
        Class<EhcacheFactory> clazz = EhcacheFactory.class;
        synchronized (EhcacheFactory.class) {
            if (cacheManager != null) return cacheManager;
            cacheManager = CacheManager.create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Cache getOrAddCache(String cacheName) {
        CacheManager cacheManager = EhcacheFactory.getCacheManager();
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            CacheManager cacheManager2 = cacheManager;
            synchronized (cacheManager2) {
                cache = cacheManager.getCache(cacheName);
                if (cache == null) {
                    log.warn("Could not find cache config [" + cacheName + "], using default.");
                    cacheManager.addCacheIfAbsent(cacheName);
                    cache = cacheManager.getCache(cacheName);
                    log.debug("Cache [" + cacheName + "] started.");
                }
            }
        }
        return cache;
    }

    @Override
    public void put(String cacheName, Object key, Object value) {
        EhcacheFactory.getOrAddCache(cacheName).put(new Element(key, value));
    }

    @Override
    public <T> T get(String cacheName, Object key) {
        Element element = EhcacheFactory.getOrAddCache(cacheName).get(key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    @Override
    public List getKeys(String cacheName) {
        return EhcacheFactory.getOrAddCache(cacheName).getKeys();
    }

    @Override
    public void remove(String cacheName, Object key) {
        EhcacheFactory.getOrAddCache(cacheName).remove(key);
    }

    @Override
    public void removeAll(String cacheName) {
        EhcacheFactory.getOrAddCache(cacheName).removeAll();
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data);
        }
        return data;
    }

    @Override
    public <T> T get(String cacheName, Object key, Class<? extends IDataLoader> dataLoaderClass) {
        Object data = this.get(cacheName, key);
        if (data == null) {
            try {
                IDataLoader dataLoader = dataLoaderClass.newInstance();
                data = dataLoader.load();
                this.put(cacheName, key, data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }

    static {
        log = LoggerFactory.getLogger(EhcacheFactory.class);
    }

    private static enum CoCoEhcache {
        instance;

        private EhcacheFactory factory = new EhcacheFactory();

        private EhcacheFactory init() {
            return this.factory;
        }
    }
}

