package com.ovopark.boot.cache.ehCache;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ovopark.boot.cache.BaseCacheFactory;
import com.ovopark.boot.cache.IDataLoader;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
/**
 * 
    * @ClassName: EhcacheFactory
    * @Description: TODO( Ehcache实现类)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年8月28日 上午10:23:37
 */
public class EhcacheFactory extends BaseCacheFactory{
	
	private enum CoCoEhcache{
		instance;
		private EhcacheFactory factory;
		CoCoEhcache(){
			factory=new EhcacheFactory();
		}
		private EhcacheFactory init(){
	        return factory;
	    }
	}
	public static EhcacheFactory createEhcache() {
		return CoCoEhcache.instance.init();
	}
	
	private static volatile CacheManager cacheManager;
	private static final Logger log = LoggerFactory.getLogger(EhcacheFactory.class);
	public static CacheManager getCacheManager() {
		if (cacheManager == null) {
			synchronized (EhcacheFactory.class) {
				if (cacheManager == null) {
					cacheManager = CacheManager.create();
				}
			}
		}
		return cacheManager;
	}
	
	static Cache getOrAddCache(String cacheName) {
		CacheManager cacheManager = getCacheManager();
		Cache cache = cacheManager.getCache(cacheName);
		if (cache == null) {
			synchronized(cacheManager) {
				cache = cacheManager.getCache(cacheName);
				if (cache == null) {
					log.warn("Could not find cache config [" + cacheName + "], using default.");
					cacheManager.addCacheIfAbsent(cacheName);
					cache = cacheManager.getCache(cacheName);
					log.debug("Cache [" + cacheName + "] started.");
				}
			}
		}
		return cache;
	}
	
	public void put(String cacheName, Object key, Object value) {
		getOrAddCache(cacheName).put(new Element(key, value));
	}
	
	@SuppressWarnings("unchecked")
	public  <T> T get(String cacheName, Object key) {
		Element element = getOrAddCache(cacheName).get(key);
		return element != null ? (T)element.getObjectValue() : null;
	}
	
	@SuppressWarnings("rawtypes")
	public  List getKeys(String cacheName) {
		return getOrAddCache(cacheName).getKeys();
	}
	
	public  void remove(String cacheName, Object key) {
		getOrAddCache(cacheName).remove(key);
	}
	
	public  void removeAll(String cacheName) {
		getOrAddCache(cacheName).removeAll();
	}
	
	@SuppressWarnings("unchecked")
	public  <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
		Object data = get(cacheName, key);
		if (data == null) {
			data = dataLoader.load();
			put(cacheName, key, data);
		}
		return (T)data;
	}
	
	@SuppressWarnings("unchecked")
	public  <T> T get(String cacheName, Object key, Class<? extends IDataLoader> dataLoaderClass) {
		Object data = get(cacheName, key);
		if (data == null) {
			try {
				IDataLoader dataLoader = dataLoaderClass.newInstance();
				data = dataLoader.load();
				put(cacheName, key, data);
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
		return (T)data;
	}
}
