package com.ovopark.boot.cache.redis.service;

import com.ovopark.boot.cache.Redis;

public interface BootRedisService extends Redis{

	/**
	 * 取出并反序列化对象
	 * @param key
	 * @param obj
	 * @param index
	 * @return
	 */
	public boolean setObject(String key, Object obj, int index);

	/**
	 * 序列化对象直接存储
	 * @param key
	 * @param index
	 * @return
	 */
	public byte[] getObject(String key, int index);
	
	public Long dbsize(int index);

	/**
	 * Redis SetNX（SET if Not exists）
	 * 命令在指定的key不存在时，为key设置指定的值。
	 * 设置成功，返回1。设置失败，返回0。
	 *
	 * @param key   key
	 * @param value value
	 * @return
	 */
	Long setNX(String key, String value);

	/**
	 * Redis SetNX（SET if Not exists）
	 * 命令在指定的key不存在时，为key设置指定的值。
	 * 设置成功，返回1。设置失败，返回0。
	 *
	 * @param key   key
	 * @param value value
	 * @param index redis库
	 * @return
	 */
	Long setNX(String key, String value, Integer index);

	/***
	 * 将值value关联到key，并将key的生存时间设为seconds(以秒为单位)。
	 * 如果key已经存在，setEX命令将覆写旧值。
	 * 这个命令类似于以下两个命令：
	 * SET key value
	 * EXPIRE key seconds
	 * 不同之处是，setEX是一个原子性(atomic)操作，关联值和设置生存时间两个动作会在同一时间内完成，该命令在Redis用作缓存时，非常实用。
	 *
	 * @param key key
	 * @param value value
	 * @param seconds 过期时长 单位：秒
	 * @return
	 */
	Boolean setEX(String key, String value, Integer seconds);

	/***
	 * 将值value关联到key，并将key的生存时间设为seconds(以秒为单位)。
	 * 如果key已经存在，setEX命令将覆写旧值。
	 * 这个命令类似于以下两个命令：
	 * SET key value
	 * EXPIRE key seconds
	 * 不同之处是，setEX是一个原子性(atomic)操作，关联值和设置生存时间两个动作会在同一时间内完成，该命令在Redis用作缓存时，非常实用。
	 *
	 * @param key key
	 * @param value value
	 * @param seconds 过期时长 单位：秒
	 * @param index redis库
	 * @return
	 */
	Boolean setEX(String key, String value, Integer seconds, Integer index);

	/**
	 * key 是否存在
	 *
	 * @param key key
	 * @return
	 */
	Boolean exists(String key);

	/**
	 * key 是否存在
	 *
	 * @param key   key
	 * @param index redis库
	 * @return
	 */
	Boolean exists(String key, Integer index);
}
