/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.common.code.support;

import com.ovopark.boot.common.code.AbstractReturnCode;
import com.ovopark.boot.common.code.ApiReturnCode;
import com.ovopark.boot.common.code.CommonApiReturnCode;
import com.ovopark.boot.common.plugin.activerecord.GG;

public class ApiCodeResult {
    public static <T> GG<T> success() {
        return ApiCodeResult.success(ApiReturnCode.SUCCESS, "");
    }

    public static <T> GG<T> success(Object data) {
        return ApiCodeResult.success(ApiReturnCode.SUCCESS, data);
    }

    public static <T> GG<T> success(AbstractReturnCode code) {
        return ApiCodeResult.success(ApiReturnCode.SUCCESS, "");
    }

    public static <T> GG<T> success(AbstractReturnCode code, Object data) {
        return ApiCodeResult.output(code, data, false);
    }

    public static <T> GG<T> error() {
        return ApiCodeResult.error(CommonApiReturnCode.API_SERVICE_ERROR, "");
    }

    public static <T> GG<T> error(AbstractReturnCode code) {
        return ApiCodeResult.error(code, "");
    }

    public static <T> GG<T> error(AbstractReturnCode code, Object data) {
        return ApiCodeResult.output(code, data, true);
    }

    public static <T> GG<T> output(AbstractReturnCode Abcode, Object data, boolean isError) {
        GG gg = new GG();
        gg.setIsError(isError);
        gg.setCode(Abcode.getCode());
        gg.setCodename(Abcode.getName());
        gg.setResult(Abcode.getDesc());
        gg.setData(data);
        return gg;
    }

    public static <T> GG<T> successMsg(String msg) {
        ApiReturnCode code = new ApiReturnCode("\u6210\u529f", "SUCCESS", 0);
        code.setDesc(msg);
        return ApiCodeResult.output(code, "", false);
    }

    public static <T> GG<T> errorMsg(AbstractReturnCode code, String msg) {
        ApiReturnCode codeNew = new ApiReturnCode(msg, code.getName(), code.getCode());
        return ApiCodeResult.output(codeNew, "", true);
    }
}

