package com.ovopark.boot.common.code.support;

import com.ovopark.boot.common.code.AbstractReturnCode;
import com.ovopark.boot.common.code.ApiReturnCode;
import com.ovopark.boot.common.code.CommonApiReturnCode;
import com.ovopark.boot.common.plugin.activerecord.GG;

/**
    * @ClassName: ApiCodeResult
    * @Description: TODO(返回码处理)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date  2018年8月29日 下午2:10:41 
    *
 */
public class ApiCodeResult {
	
	public static <T> GG<T> success() {
		return success(ApiReturnCode.SUCCESS,"");
	}
	public static <T> GG<T> success(Object data) {
		return success(ApiReturnCode.SUCCESS,data);
	}
	public static <T> GG<T> success(AbstractReturnCode code) {
		return success(ApiReturnCode.SUCCESS,"");
	}
	public static <T> GG<T> success(AbstractReturnCode code,Object data) {
		return output(code,data,false);
	}
	public static <T> GG<T> error() {
		return error(CommonApiReturnCode.API_SERVICE_ERROR,"");
	}
	public static <T> GG<T> error(AbstractReturnCode code) {
		return error(code, "");
	}
	public static <T> GG<T> error(AbstractReturnCode code,Object data) {
		return output(code, data,true);
	}
	
	public static <T> GG<T> output(AbstractReturnCode Abcode,Object data,boolean isError){
		GG<T> gg=new GG<T>();
		gg.setIsError(isError);
		gg.setCode(Abcode.getCode());
		gg.setCodename(Abcode.getName());
		gg.setResult(Abcode.getDesc());
		gg.setData((T)data);
		return gg;
	}
	
	public static <T> GG<T> successMsg(String msg) {
		AbstractReturnCode code=new ApiReturnCode("成功", "SUCCESS", CommonApiReturnCode.SUCCESS_CODE);
		code.setDesc(msg);
		return output(code,"",false);
	}
	
	public static <T> GG<T> errorMsg(AbstractReturnCode code,String msg) {
		AbstractReturnCode codeNew=new ApiReturnCode(msg, code.getName(),code.getCode());
		return output(codeNew, "",true);
	}
}
