package com.ovopark.boot.common.code;

/**
 * 
    * @ClassName: ApiReturnCode
    * @Description: TODO(网关返回码)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年9月14日 上午11:17:31
    * 
    * 错误码区间 eg:100001(前3位为系统编号,子系统可作为换位符，如当前系统编号，如当前系统编号为100，后三位为异常码如001)
 */
public class ApiReturnCode extends AbstractReturnCode{
	private static final long serialVersionUID = -1477827287408858436L;
	// 成功
	public static final int SUCCESS_CODE = 0;
	public final static AbstractReturnCode SUCCESS = new ApiReturnCode("成功", "SUCCESS", SUCCESS_CODE);

	public ApiReturnCode(String desc, String name, int code) {
		super(desc, name, code);
	}
	
	//参数效验异常
	public static final int PARAMETER_VALIDATE_ERROR_CODE=100004;	
	public final  static AbstractReturnCode PARAMETER_VALIDATE_ERROR = new ApiReturnCode("参数效验异常","PARAMETER_VALIDATE_ERROR", PARAMETER_VALIDATE_ERROR_CODE);
	//api服务异常
	public static final int API_SERVICE_ERROR_CODE = 100999;
	public final static AbstractReturnCode API_SERVICE_ERROR = new ApiReturnCode("api服务未知异常", "API_SERVICE_ERROR",API_SERVICE_ERROR_CODE);
	
	// 系统内部异常
	public static final int API_SYSTEM_ERROR_CODE=-999;	
	public final static AbstractReturnCode API_SYSTEM_ERROR = new ApiReturnCode("网关返回未知异常","API_SYSTEM_ERROR", API_SYSTEM_ERROR_CODE);

	//不支持的媒体类型
	public static final int NOT_SUPPORT_MEDIATYPE_CODE=100005;
	public final  static AbstractReturnCode NOT_SUPPORT_MEDIATYPE = new ApiReturnCode("不支持的媒体类型","NOT_SUPPORT_MEDIATYPE", NOT_SUPPORT_MEDIATYPE_CODE);

}
