package com.ovopark.boot.common.code;


/**
 * 
 * @ClassName: CommonApiReturnCode
 * @Description:TODO(公共返回码，公共返回码区间999000~999999)
 * @author: Remiel_Mercy
 * @date: 2019年3月4日 下午4:39:18
 * 
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public class CommonApiReturnCode extends AbstractReturnCode {

	public CommonApiReturnCode(String desc, String name, int code) {
		super(desc, name, code);
	}

	/**
	 * @Fields serialVersionUID : TODO(用一句话描述这个变量表示什么)
	 */
	private static final long serialVersionUID = -6961378011769305066L;

	// 成功
	public static final int SUCCESS_CODE = 0;
	public final static AbstractReturnCode SUCCESS = new CommonApiReturnCode("成功", "SUCCESS", SUCCESS_CODE);
	
	// 无效的token
	public static final Integer INVALID_TOKEN_CODE = 9990001;
	public final  static ApiReturnCode INVALID_TOKEN = new ApiReturnCode("无效的token","INVALID_TOKEN", INVALID_TOKEN_CODE);

	//token已过期
	public static final Integer TOKEN_EXPIRED_CODE = 9990002;
	public final  static ApiReturnCode TOKEN_EXPIRED = new ApiReturnCode("token已过期","TOKEN_EXPIRED", TOKEN_EXPIRED_CODE);
	
	
	//参数效验异常
	public static final int PARAMETER_VALIDATE_ERROR_CODE=999004;	
	public final  static AbstractReturnCode PARAMETER_VALIDATE_ERROR = new ApiReturnCode("参数效验异常","PARAMETER_VALIDATE_ERROR", PARAMETER_VALIDATE_ERROR_CODE);

	//edas签名不能为空
	public static final int EDAS_SIGN_NOT_NULL_CODE=999005;	
	public final  static AbstractReturnCode EDAS_SIGN_NOT_NULL = new ApiReturnCode("edas服务签名不能为空","EDAS_SIGN_NOT_NULL", EDAS_SIGN_NOT_NULL_CODE);

	//edas签名错误
	public static final int EDAS_SIGN_WRONG_CODE=999006;	
	public final  static AbstractReturnCode EDAS_SIGN_WRONG = new ApiReturnCode("edas服务签名错误","EDAS_SIGN_WRONG", EDAS_SIGN_WRONG_CODE);

	//请求方法不支持
	public static final int REQUEST_METHOD_NOT_SUPPORTED_CODE=999007;	
	public final  static AbstractReturnCode REQUEST_METHOD_NOT_SUPPORTED = new ApiReturnCode("请求方法不支持","REQUEST_METHOD_NOT_SUPPORTED", REQUEST_METHOD_NOT_SUPPORTED_CODE);

	//身份信息违法，密匙秘钥与企业id不匹配
	public static final int IDENTITY_INFORMATION_WRONG_CODE=999008;	
	public final static AbstractReturnCode IDENTITY_INFORMATION_WRONG = new ApiReturnCode("身份信息有误!_akey、与企业id不匹配","IDENTITY_INFORMATION_WRONG", IDENTITY_INFORMATION_WRONG_CODE);
	
	//身份信息违法，密匙秘钥与企业id不匹配
	public static final int  JSON_PARSE_ERROR_CODE=999009;	
	public final static AbstractReturnCode JSON_PARSE_ERROR = new ApiReturnCode("JSON解析异常","JSON_PARSE_ERROR", JSON_PARSE_ERROR_CODE);
	
	//文件下载失败
	public static final int  FILE_DOWNLOAD_ERROR_CODE=999010;	
	public final static AbstractReturnCode FILE_DOWNLOAD_ERROR = new ApiReturnCode("文件下载失败","FILE_DOWNLOAD_ERROR", FILE_DOWNLOAD_ERROR_CODE);
	
	public static final int UNTRUSTED_IP_CODE = 999011;
    public final static AbstractReturnCode UNTRUSTED_IP = new ApiReturnCode("not allow to access from your ip", "UNTRUSTED_IP", UNTRUSTED_IP_CODE);

	
	// 服务请求超时
	public static final int SERVICE_TIMEOUT_CODE = 999066;
	public final static AbstractReturnCode SERVICE_TIMEOUT = new CommonApiReturnCode("服务请求超时", "SERVICE_TIMEOUT",
			SERVICE_TIMEOUT_CODE);

	// token格式有误
	public static final int TOKEN_FORMAT_ERROR_CODE = 999096;
	public final static AbstractReturnCode TOKEN_FORMAT_ERROR = new CommonApiReturnCode("token格式有误", "TOKEN_FORMAT_ERROR",
			TOKEN_FORMAT_ERROR_CODE);
	// root帐号无法操作此接口
	public static final int NO_AUTHORITY_CODE = 999097;
	public final static AbstractReturnCode NO_AUTHORITY = new CommonApiReturnCode("root帐号无法操作此接口", "NO_AUTHORITY",
			NO_AUTHORITY_CODE);
	// token不能为空
	public static final int TOKEN_NOT_NULL_CODE = 999098;
	public final static AbstractReturnCode TOKEN_NOT_NULL = new CommonApiReturnCode("token不能为空", "TOKEN_NOT_NULL",
			TOKEN_NOT_NULL_CODE);
	// token不能为空
	public static final int PERMISSION_DENIED_CODE = 999099;
	public final static AbstractReturnCode PERMISSION_DENIED = new CommonApiReturnCode("Permission denied", "PERMISSION_DENIED",
			PERMISSION_DENIED_CODE);
	//api服务异常
	public static final int API_SERVICE_ERROR_CODE = 999999;
	public final static AbstractReturnCode API_SERVICE_ERROR = new ApiReturnCode("api服务未知异常", "API_SERVICE_ERROR",API_SERVICE_ERROR_CODE);

}
