package com.ovopark.boot.dp.plugin.mongodb;

import java.util.List;

import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import com.ovopark.boot.common.plugin.activerecord.Page;


/**
    * @ClassName: MongoDbService
    * @Description: TODO(MongoDb 接口)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date  2017年11月15日 下午6:17:41 
    *
 */
public interface MongoDbService {
	/**
	 * 
	    * @Title: save
	    * @Description: TODO(插入一条记录)
	    * @param @param entity    对象
	    * @return void    返回类型
	    * @throws
	 */
	@Deprecated
	<T> void save(T entity);

	/**
	 *
	 * @Title: save
	 * @Description: TODO(插入一条记录)
	 * @apiNote 应急手段，解决调取不到方法的问题
	 * @param @param entity    对象
	 * @return void    返回类型
	 * @throws
	 */
//	<T> void save2(T entity);

	<T>  void saveOrUpdate(Object entity,Object id); 
	/**
	    * @Title: save
	    * @Description: TODO(根据集合插入一条记录)
	    * @param @param collectionName
	    * @param @param entity    参数
	    * @return void    返回类型
	    * @throws
	 */
	@Deprecated
	<T> void save(String collectionName,T entity);

	/**
	 * @Title: save
	 * @Description: TODO(根据集合插入一条记录)
	 * @apiNote 应急手段，解决调取不到方法的问题
	 * @param @param collectionName
	 * @param @param entity    参数
	 * @return void    返回类型
	 * @throws
	 */
//	<T> void save2(String collectionName,T entity);

	<T> void saveOrUpdate(Object entity,Object id,String collectionName); 
	/**
	 * 
	    * @Title: delete
	    * @Description: TODO(根据条件，集合删除)
	    * @param @param query 条件
	    * @param @param collectionName    集合名称
	    * @return void    返回类型
	    * @throws
	 */
	<T> void delete(Query query,String collectionName);
	/**
	    * @Title: updateFirst
	    * @Description: TODO(更新满足条件的第一个记录)
	    * @param @param query 条件
	    * @param @param update 更新内容
	    * @param @param collectionName    参数
	    * @return void    返回类型
	    * @throws
	 */
	<T> void updateFirst(Query query,Update update,String collectionName);
	/**
	    * @Title: updateMulti
	    * @Description: TODO(更新满足条件的所有记录)
	    * @param @param query 条件
	    * @param @param update	更新内容
	    * @param @param collectionName    参数
	    * @return void    返回类型
	    * @throws
	 */
	<T> void updateMulti(Query query,Update update,String collectionName);
	/**
	 * 
	    * @Title: upsert
	    * @Description: TODO(查找更新,如果没有找到符合的记录,则将更新的记录插入库中)
	    * @param @param query
	    * @param @param update
	    * @param @param collectionName    参数
	    * @return void    返回类型
	    * @throws
	 */
	<T> void upsert(Query query,Update update,String collectionName);
	/**
	    * @Title: findById
	    * @Description: TODO(根据id查询一个对象)
	    * @param @param id   id
	    * @param @param collectionName  集合名称
	    * @param @param clazz  类
	    * @param @return    参数
	    * @return T    返回类型
	    * @throws
	 */
	<T> T findById(String id, String collectionName,Class<T> clazz) ;
	/**
	    * @Title: queryOne
	    * @Description: TODO(通过条件查询单个实体)
	    * @param @param query 查询条件
	    * @param @param clazz 类
	    * @param @return    参数
	    * @return T    返回类型
	    * @throws
	 */
	<T> T queryOne(Query query,Class<T> clazz);
	/**
	 * 
	    * @Title: queryOne
	    * @Description: TODO(通过条件,集合名称查询单个实体)
	    * @param @param query  查询条件
	    * @param @param collectionName 集合名称
	    * @param @param clazz 类
	    * @param @return    参数
	    * @return T    返回类型
	    * @throws
	 */
	<T> T queryOne(Query query, String collectionName,Class<T> clazz);
	/**
	    * @Title: findAll
	    * @Description: TODO(查询实体)
	    * @param @param clazz 类
	    * @param @return    参数
	    * @return List<T>    返回类型
	    * @throws
	 */
	<T> List<T> findAll(Class<T> clazz); 
	/**
	    * @Title: findAll
	    * @Description: TODO(根据集合名称，查询实体)
	    * @param @param collectionName 集合名称
	    * @param @param clazz  类
	    * @param @return    参数
	    * @return List<T>    返回类型
	    * @throws
	 */
	<T> List<T> findAll(String collectionName,Class<T> clazz); 
	/**
	    * @Title: queryList
	    * @Description: TODO(根据条件查询集合列表)
	    * @param @param query  查询条件
	    * @param @param clazz  类
	    * @param @return    参数
	    * @return List<T>    返回类型
	    * @throws
	 */
	<T> List<T> queryList(Query query,Class<T> clazz);
	/**
	    * @Title: queryList
	    * @Description: TODO(根据条件，集合名称查询集合列表)
	    * @param @param query   查询条件
	    * @param @param collectionName  集合
	    * @param @param clazz  类
	    * @param @return    参数
	    * @return List<T>    返回类型
	    * @throws
	 */
	<T> List<T> queryList(Query query, String collectionName,Class<T> clazz);
	
	/**
	    * @Title: paginate
	    * @Description: TODO(分页查询)
	    * @param @param clazz
	    * @param @param pageNumber
	    * @param @param pageSize
	    * @param @return    参数
	    * @return Page<T>    返回类型
	    * @throws
	 */
	<T> Page<T>  paginate(Class<T> clazz,int pageNumber, int pageSize);
	<T> Page<T>  paginate(String collectionName,Class<T> clazz,int pageNumber, int pageSize);
	<T> Page<T>  paginate( Query query,Class<T> clazz,int pageNumber, int pageSize);
	<T> Page<T>  paginate( Query query, String collectionName,Class<T> clazz,int pageNumber, int pageSize);


	/**
	    * @Title: getCount
	    * @Description: TODO(根据条件查询库中符合记录的总数)
	    * @param @param query
	    * @param @param clazz
	    * @param @return    参数
	    * @return Long    返回类型
	    * @throws
	 */
	<T> Long getCount(Query query,Class<T> clazz);
	<T> Long getCount(Query query,String collectionName,Class<T> clazz);
	<T> Long getCount(Query query,String collectionName);
	
	<T> AggregationResults<T> aggregate(Aggregation aggregation,String collectionName, Class<T> clazz);
}
