package com.ovopark.boot.dp.plugin.mongodb.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import com.ovopark.boot.common.plugin.activerecord.Page;
import com.ovopark.boot.dp.plugin.mongodb.MongoDbService;
import com.ovopark.boot.kit.reflect.ReflectKit;

/**
    * @ClassName: MongoDbServiceImpl
    * @Description: TODO(MongoDb接口实现类)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date  2017年11月16日 上午9:51:37 
    *
 */
@Component
public class MongoDbServiceImpl implements  MongoDbService{
	private static Logger log = LoggerFactory.getLogger(MongoDbServiceImpl.class);
	private boolean isshowSql = true;
	@Autowired
	private MongoTemplate mt;
//	private Class mtClass;

//	public MongoDbServiceImpl(@Autowired MongoTemplate mt){
//		this.mt = mt;
//		mtClass = mt.getClass();
//	}

	@Override
	public <T> void save(T entity) {
		if (isshowSql) {
			log.info("[MongoDb] save >>> entity:{}" ,entity);
		}
		mt.save(entity);
	}

//	@Override
//	public <T> void save2(T entity) {
//		if(isshowSql) {
//			log.info("[MongoDb] save >>> entity:{}" ,entity);
//		}
//		try {
//			Method save = mtClass.getMethod("save", Object.class);
//			save.invoke(this.mt, entity);
//		} catch (NoSuchMethodException var4) {
//			var4.printStackTrace();
//		} catch (IllegalAccessException var5) {
//			var5.printStackTrace();
//		} catch (InvocationTargetException var6) {
//			var6.printStackTrace();
//		}
//	}

	@Override
	public <T> void save(String collectionName, T entity) {
		if (isshowSql) {
			log.info("[MongoDb] save >>> collectionName:{},entity:{}" ,collectionName,entity);
		}
		mt.save(entity,collectionName);
	}

//	@Override
//	public <T> void save2(String collectionName, T entity) {
//		if (isshowSql) {
//			log.info("[MongoDb] save >>> collectionName:{},entity:{}" ,collectionName,entity);
//		}
//		try {
//			Method save = mtClass.getMethod("save", Object.class,String.class);
//			save.invoke(this.mt, entity,collectionName);
//		} catch (NoSuchMethodException var4) {
//			var4.printStackTrace();
//		} catch (IllegalAccessException var5) {
//			var5.printStackTrace();
//		} catch (InvocationTargetException var6) {
//			var6.printStackTrace();
//		}
//	}

	@Override
	public <T> void delete(Query query,String collectionName){
		if (isshowSql) {
			log.info("[MongoDb] delete >>> query:{},collectionName:{}" ,query,collectionName);
		}
		mt.remove(query, collectionName);
	}
	@Override
	public <T> void updateFirst(Query query,Update update,String collectionName){
		if (isshowSql) {
			log.info("[MongoDb] updateFirst >>> query:{},update:{},collectionName:{}" , new Object[]{query,update,collectionName});
		}
		mt.updateFirst(query, update, collectionName);
	}
	@Override
	public <T> void updateMulti(Query query,Update update,String collectionName){
		if (isshowSql) {
			log.info("[MongoDb] updateMulti >>> query:{},update:{},collectionName:{}" , new Object[]{query,update,collectionName});
		}
		mt.updateMulti(query, update, collectionName);
	}
	@Override
	public <T> void upsert(Query query, Update update, String collectionName) {
		if (isshowSql) {
			log.info("[MongoDb] upsert >>> query:{},update:{},collectionName:{}" , new Object[]{query,update,collectionName});
		}
		mt.upsert(query, update, collectionName);
	}
	@Override
	public <T> T findById(String id, String collectionName,Class<T> clazz) {
		if (isshowSql) {
			log.info("[MongoDb] findById >>> id:{},collectionName:{}" ,id,collectionName);
		}
		return mt.findById(id, clazz, collectionName);
	}
	@Override
	public <T> T queryOne(Query query,Class<T> clazz) {
		if (isshowSql) {
			log.info("[MongoDb]	queryOne >>> query:{}" , query);
		}
		return mt.findOne(query, clazz);
	}
	@Override
	public <T> T queryOne(Query query, String collectionName, Class<T> clazz) {
		if (isshowSql) {
			log.info("[MongoDb]	queryOne >>> query:{},collectionName:{}" , query,collectionName);
		}
		return mt.findOne(query, clazz,collectionName);
	}
	@Override
	public <T> List<T> findAll(Class<T> clazz) {
		if (isshowSql) {
			log.info("[MongoDb]	findAll >>> clazz:{}",clazz.getName());
		}
		return mt.findAll(clazz);
	}
	@Override
	public <T> List<T> findAll(String collectionName,Class<T> clazz) {
		if (isshowSql) {
			log.info("[MongoDb]	findAll >>> collectionName:{}" , collectionName);
		}
		return mt.findAll(clazz, collectionName);
	}
	@Override
	public <T> List<T> queryList(Query query, Class<T> clazz) {
		if (isshowSql) {
			log.info("[MongoDb]	queryList >>> query:{}" , query);
		}
		return mt.find(query, clazz);
	}
	@Override
	public <T> List<T> queryList(Query query, String collectionName, Class<T> clazz) {
		if (isshowSql) {
			log.info("[MongoDb]	queryList >>> query:{},collectionName:{}" , query,collectionName);
		}
		return mt.find(query, clazz,collectionName);
	}
	@Override
	public <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize) {
		if (isshowSql) {
			log.info("[MongoDb]	paginate >>> clazz:{}" , clazz.getName());
		}
		Query query=new Query();
		query.skip(pageNumber);
		query.limit(pageSize);
		List<T> list=mt.find(query, clazz);
		Page<T> p=new Page<T>();
		p.setList(list);
		p.setPageNumber(pageNumber);
		p.setPageSize(pageSize);
		Long total=Long.valueOf(list.size());
		p.setTotal(total);
		return p;
	}
	@Override
	public <T> Page<T> paginate(String collectionName, Class<T> clazz, int pageNumber, int pageSize) {
		if (isshowSql) {
			log.info("[MongoDb]	paginate >>>collectionName:{}" ,collectionName);
		}
		Query query=new Query();
		query.skip(pageNumber);
		query.limit(pageSize);
		List<T> list=mt.find(query, clazz,collectionName);
		Page<T> p=new Page<T>();
		p.setList(list);
		p.setPageNumber(pageNumber);
		p.setPageSize(pageSize);
		Long total=Long.valueOf(list.size());
		p.setTotal(total);
		return p;
	}
	@Override
	public <T> Page<T> paginate(Query query, Class<T> clazz, int pageNumber, int pageSize) {
		if (isshowSql) {
			log.info("[MongoDb]	paginate >>>query:{}" ,query);
		}
		query.skip(pageNumber);
		query.limit(pageSize);
		List<T> list=mt.find(query, clazz);
		Page<T> p=new Page<T>();
		p.setList(list);
		p.setPageNumber(pageNumber);
		p.setPageSize(pageSize);
		Long total=Long.valueOf(list.size());
		p.setTotal(total);
		return p;
	}
	@Override
	public <T> Page<T> paginate(Query query, String collectionName, Class<T> clazz, int pageNumber, int pageSize) {
		if (isshowSql) {
			log.info("[MongoDb]	paginate >>>query:{},collectionName:{}" ,query,collectionName);
		}
		query.skip(pageNumber);
		query.limit(pageSize);
		List<T> list=mt.find(query, clazz,collectionName);
		Page<T> p=new Page<T>();
		p.setList(list);
		p.setPageNumber(pageNumber);
		p.setPageSize(pageSize);
		Long total=Long.valueOf(list.size());
		p.setTotal(total);
		return p;
	}
	@Override
	public <T> Long getCount(Query query, Class<T> clazz) {
		if (isshowSql) {
			log.info("[MongoDb]	getCount >>>query:{}" ,query);
		}
		return mt.count(query, clazz);
	}
	@Override
	public <T> Long getCount(Query query, String collectionName, Class<T> clazz) {
		if (isshowSql) {
			log.info("[MongoDb]	getCount >>>query:{},collectionName:{}" ,query,collectionName);
		}
		return mt.count(query, clazz, collectionName);
	}
	@Override
	public <T> Long getCount(Query query, String collectionName) {
		if (isshowSql) {
			log.info("[MongoDb]	getCount >>>query:{},collectionName:{}" ,query,collectionName);
		}
		return mt.count(query, collectionName);
	}
	public MongoTemplate getMt() {
		return mt;
	}
	
	public boolean isIsshowSql() {
		return isshowSql;
	}
	public void setIsshowSql(boolean isshowSql) {
		this.isshowSql = isshowSql;
	}

	public MongoDbServiceImpl() {

	}
	@Override
	public <T> AggregationResults<T> aggregate(Aggregation aggregation,String collectionName, Class<T> clazz) {
		if (isshowSql) {
			log.info("[MongoDb] aggregate >>> aggregation:{},collectionName:{}" ,aggregation,collectionName);
		}
		return  mt.aggregate(aggregation, collectionName, clazz);
	}
	@Override
	public void saveOrUpdate(Object entity,Object id) {
		if (isshowSql) {
			log.info("[MongoDb] save >>> entity:{},id:{}" ,entity,id);
		}
		Query query = Query.query(Criteria.where("_id").is(id));
		Update update = new Update();
		Class<?> clazz = entity.getClass();
		Field[] fields =ReflectKit.getNeedFields(clazz);
		for (Field field : fields) {
			 try {
				  // 抑制Java对修饰符的检查
			      field.setAccessible(true);
			      //反射对应的字段名  
			      String k=field.getName();
			      //获取字段set的值
			      Object v=field.get(entity);
			      update.set(k, v);//保存到mongodb update对象中
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
		}
		mt.upsert(query, update,clazz);
		
	}
	@Override
	public void saveOrUpdate(Object entity,Object id,String collectionName) {
		if (isshowSql) {
			log.info("[MongoDb] save >>> collectionName:{},entity:{},id:{}" ,collectionName,entity,id);
		}
		Query query = Query.query(Criteria.where("_id").is(id));
		Update update = new Update();
		Class<?> clazz = entity.getClass();
		Field[] fields =ReflectKit.getNeedFields(clazz);
		for (Field field : fields) {
			 try {
				  // 抑制Java对修饰符的检查
			      field.setAccessible(true);
			      //反射对应的字段名  
			      String k=field.getName();
			      //获取字段set的值
			      Object v=field.get(entity);
			      update.set(k, v);//保存到mongodb update对象中
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
		}
		mt.upsert(query, update,clazz,collectionName);
		
	}

	

	
	
}
