/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.dp.plugin.mongodb.impl;

import com.ovopark.boot.common.plugin.activerecord.Page;
import com.ovopark.boot.dp.plugin.mongodb.MongoDbService;
import com.ovopark.boot.kit.reflect.ReflectKit;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
public class MongoDbServiceImpl
implements MongoDbService {
    private static Logger log = LoggerFactory.getLogger(MongoDbServiceImpl.class);
    private boolean isshowSql = true;
    @Autowired
    private MongoTemplate mt;

    @Override
    public <T> void save(T entity) {
        if (this.isshowSql) {
            log.info("[MongoDb] save >>> entity:{}", entity);
        }
        this.mt.save(entity);
    }

    @Override
    public <T> void save(String collectionName, T entity) {
        if (this.isshowSql) {
            log.info("[MongoDb] save >>> collectionName:{},entity:{}", (Object)collectionName, entity);
        }
        this.mt.save(entity, collectionName);
    }

    @Override
    public <T> void delete(Query query, String collectionName) {
        if (this.isshowSql) {
            log.info("[MongoDb] delete >>> query:{},collectionName:{}", (Object)query, (Object)collectionName);
        }
        this.mt.remove(query, collectionName);
    }

    @Override
    public <T> void updateFirst(Query query, Update update, String collectionName) {
        if (this.isshowSql) {
            log.info("[MongoDb] updateFirst >>> query:{},update:{},collectionName:{}", new Object[]{query, update, collectionName});
        }
        this.mt.updateFirst(query, update, collectionName);
    }

    @Override
    public <T> void updateMulti(Query query, Update update, String collectionName) {
        if (this.isshowSql) {
            log.info("[MongoDb] updateMulti >>> query:{},update:{},collectionName:{}", new Object[]{query, update, collectionName});
        }
        this.mt.updateMulti(query, update, collectionName);
    }

    @Override
    public <T> void upsert(Query query, Update update, String collectionName) {
        if (this.isshowSql) {
            log.info("[MongoDb] upsert >>> query:{},update:{},collectionName:{}", new Object[]{query, update, collectionName});
        }
        this.mt.upsert(query, update, collectionName);
    }

    @Override
    public <T> T findById(String id, String collectionName, Class<T> clazz) {
        if (this.isshowSql) {
            log.info("[MongoDb] findById >>> id:{},collectionName:{}", (Object)id, (Object)collectionName);
        }
        return (T)this.mt.findById((Object)id, clazz, collectionName);
    }

    @Override
    public <T> T queryOne(Query query, Class<T> clazz) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tqueryOne >>> query:{}", (Object)query);
        }
        return (T)this.mt.findOne(query, clazz);
    }

    @Override
    public <T> T queryOne(Query query, String collectionName, Class<T> clazz) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tqueryOne >>> query:{},collectionName:{}", (Object)query, (Object)collectionName);
        }
        return (T)this.mt.findOne(query, clazz, collectionName);
    }

    @Override
    public <T> List<T> findAll(Class<T> clazz) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tfindAll >>> clazz:{}", (Object)clazz.getName());
        }
        return this.mt.findAll(clazz);
    }

    @Override
    public <T> List<T> findAll(String collectionName, Class<T> clazz) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tfindAll >>> collectionName:{}", (Object)collectionName);
        }
        return this.mt.findAll(clazz, collectionName);
    }

    @Override
    public <T> List<T> queryList(Query query, Class<T> clazz) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tqueryList >>> query:{}", (Object)query);
        }
        return this.mt.find(query, clazz);
    }

    @Override
    public <T> List<T> queryList(Query query, String collectionName, Class<T> clazz) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tqueryList >>> query:{},collectionName:{}", (Object)query, (Object)collectionName);
        }
        return this.mt.find(query, clazz, collectionName);
    }

    @Override
    public <T> Page<T> paginate(Class<T> clazz, int pageNumber, int pageSize) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tpaginate >>> clazz:{}", (Object)clazz.getName());
        }
        Query query = new Query();
        query.skip((long)pageNumber);
        query.limit(pageSize);
        List list = this.mt.find(query, clazz);
        Page p = new Page();
        p.setList(list);
        p.setPageNumber(pageNumber);
        p.setPageSize(pageSize);
        Long total = list.size();
        p.setTotal(total);
        return p;
    }

    @Override
    public <T> Page<T> paginate(String collectionName, Class<T> clazz, int pageNumber, int pageSize) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tpaginate >>>collectionName:{}", (Object)collectionName);
        }
        Query query = new Query();
        query.skip((long)pageNumber);
        query.limit(pageSize);
        List list = this.mt.find(query, clazz, collectionName);
        Page p = new Page();
        p.setList(list);
        p.setPageNumber(pageNumber);
        p.setPageSize(pageSize);
        Long total = list.size();
        p.setTotal(total);
        return p;
    }

    @Override
    public <T> Page<T> paginate(Query query, Class<T> clazz, int pageNumber, int pageSize) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tpaginate >>>query:{}", (Object)query);
        }
        query.skip((long)pageNumber);
        query.limit(pageSize);
        List list = this.mt.find(query, clazz);
        Page p = new Page();
        p.setList(list);
        p.setPageNumber(pageNumber);
        p.setPageSize(pageSize);
        Long total = list.size();
        p.setTotal(total);
        return p;
    }

    @Override
    public <T> Page<T> paginate(Query query, String collectionName, Class<T> clazz, int pageNumber, int pageSize) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tpaginate >>>query:{},collectionName:{}", (Object)query, (Object)collectionName);
        }
        query.skip((long)pageNumber);
        query.limit(pageSize);
        List list = this.mt.find(query, clazz, collectionName);
        Page p = new Page();
        p.setList(list);
        p.setPageNumber(pageNumber);
        p.setPageSize(pageSize);
        Long total = list.size();
        p.setTotal(total);
        return p;
    }

    @Override
    public <T> Long getCount(Query query, Class<T> clazz) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tgetCount >>>query:{}", (Object)query);
        }
        return this.mt.count(query, clazz);
    }

    @Override
    public <T> Long getCount(Query query, String collectionName, Class<T> clazz) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tgetCount >>>query:{},collectionName:{}", (Object)query, (Object)collectionName);
        }
        return this.mt.count(query, clazz, collectionName);
    }

    @Override
    public <T> Long getCount(Query query, String collectionName) {
        if (this.isshowSql) {
            log.info("[MongoDb]\tgetCount >>>query:{},collectionName:{}", (Object)query, (Object)collectionName);
        }
        return this.mt.count(query, collectionName);
    }

    public MongoTemplate getMt() {
        return this.mt;
    }

    public boolean isIsshowSql() {
        return this.isshowSql;
    }

    public void setIsshowSql(boolean isshowSql) {
        this.isshowSql = isshowSql;
    }

    @Override
    public <T> AggregationResults<T> aggregate(Aggregation aggregation, String collectionName, Class<T> clazz) {
        if (this.isshowSql) {
            log.info("[MongoDb] aggregate >>> aggregation:{},collectionName:{}", (Object)aggregation, (Object)collectionName);
        }
        return this.mt.aggregate(aggregation, collectionName, clazz);
    }

    @Override
    public void saveOrUpdate(Object entity, Object id) {
        Field[] fields;
        if (this.isshowSql) {
            log.info("[MongoDb] save >>> entity:{},id:{}", entity, id);
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(id));
        Update update = new Update();
        Class<?> clazz = entity.getClass();
        for (Field field : fields = ReflectKit.getNeedFields(clazz)) {
            try {
                field.setAccessible(true);
                String k = field.getName();
                Object v = field.get(entity);
                update.set(k, v);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.mt.upsert(query, update, clazz);
    }

    @Override
    public void saveOrUpdate(Object entity, Object id, String collectionName) {
        Field[] fields;
        if (this.isshowSql) {
            log.info("[MongoDb] save >>> collectionName:{},entity:{},id:{}", new Object[]{collectionName, entity, id});
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(id));
        Update update = new Update();
        Class<?> clazz = entity.getClass();
        for (Field field : fields = ReflectKit.getNeedFields(clazz)) {
            try {
                field.setAccessible(true);
                String k = field.getName();
                Object v = field.get(entity);
                update.set(k, v);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.mt.upsert(query, update, clazz, collectionName);
    }
}

