package com.ovopark.boot.exception;

import java.util.HashMap;
import java.util.Map;

/**
 * 
    * @ClassName: CoCoException
    * @Description: TODO(异常基类)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年8月31日 下午2:55:18
 */
public class CoCoException extends RuntimeException {
	private static final long serialVersionUID = -6103224412679113702L;
	//错误代码
	private int errorCode;
	public int getErrorCode() {
		return errorCode;
	}
	public void setErrorCode(int errorCode) {
		this.errorCode = errorCode;
	}

	/** 错误代码和错误信息映射集合 */
	public static final Map<Integer, String> ERROR_CODE_MAP = new HashMap<Integer, String>();
	public CoCoException(){
		
	}
	public CoCoException(int errorCode) {
		super(ERROR_CODE_MAP.get(errorCode));
		this.errorCode = errorCode;
	}
	
	public CoCoException(Throwable cause) {
		super(cause);
	}	
	
	public CoCoException(int errorCode, String message) {
		super(message);
		this.errorCode = errorCode;
		ERROR_CODE_MAP.put(errorCode, message);
		
	}
	public CoCoException(int errorCode, Throwable cause) {
		super(ERROR_CODE_MAP.get(errorCode), cause);
		this.errorCode = errorCode;
	}
	public CoCoException(String message, Throwable cause) {
		super(message, cause);
	}
	public CoCoException(int errorCode, String message, Throwable cause) {
		super(message, cause);
		this.errorCode = errorCode;
		ERROR_CODE_MAP.put(errorCode, message);
	}
	//获取错误代码信息
	public String getErrorMessage() {   
	    return ERROR_CODE_MAP.get(errorCode);
	}
}
