package com.ovopark.boot.kit.cache;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
/**
 * @ClassName:  DataCacheKit   
 * @Description:TODO(简单数据缓存)   
 * @author: Remiel_Mercy 
 * @date:   2019年7月31日 下午4:08:40   
 *     
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public class DataCacheKit {

	private volatile static DataCacheKit mapCacheObject;// 缓存实例对象

	private volatile static Map<String, Object> cacheMap = new ConcurrentHashMap<String, Object>();// 缓存map

	/**
	 * 
	    * @Title: getInstance
	    * @Description: TODO(采用单例模式获取缓存对象实例)
	    * @param @return    参数
	    * @return DataCacheKit    返回类型
	    * @throws
	 */
	public static DataCacheKit getInstance() {
		if (null == mapCacheObject) {
			synchronized (DataCacheKit.class) {
				if (null == mapCacheObject) {
					mapCacheObject = new DataCacheKit();
				}
			}
		}
		return mapCacheObject;
	}

	public static void setDataCache(Map<String, Object> map) {
		Set<String> set = map.keySet();
		Iterator<String> it = set.iterator();
		while (it.hasNext()) {
			String key = it.next();
			cacheMap.put(key, map.get(key));
		}
	}

	public static Map<String, Object> getDataCache() {
		return cacheMap;
	}
	
	public static Object getDataCacheByKey(String key) {
		Object value=cacheMap.get(key);
		return value;
	}
	public static void clear() {
		cacheMap.clear();
	}
}
