package com.ovopark.boot.kit.http;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;  
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;  
import org.apache.http.client.HttpClient;  
import org.apache.http.client.config.RequestConfig;  
import org.apache.http.client.entity.UrlEncodedFormEntity;  
import org.apache.http.client.methods.CloseableHttpResponse;  
import org.apache.http.client.methods.HttpGet;  
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;  
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;  
import org.apache.http.message.BasicNameValuePair;  
import org.apache.http.util.EntityUtils;

import com.alibaba.fastjson.JSON;
import com.ovopark.boot.kit.log.LogKit;
import com.ovopark.boot.kit.reflect.ReflectKit;
import com.ovopark.boot.utils.lang.ConvertUtils;

import java.io.File;
import java.io.IOException;  
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;  
import java.util.ArrayList;  
import java.util.HashMap;  
import java.util.List;  
import java.util.Map;  

public class HttpClientKit {
    private static PoolingHttpClientConnectionManager  connMag;
    private static RequestConfig requestConfig;  
	private static final int MAX_TIMEOUT = 10000;  
	private static int maxThreadsTotal = 100;
	private static int maxThreadsPerHost = 5;
	
    static final String HTTPCLIENT_ERROR="APIGETWAY_HTTP_ERROR";
	
	private enum initHttp{
		instance;
		private HttpClientKit t;
		initHttp(){
			t=new HttpClientKit();
			// 设置连接池  
			connMag=new PoolingHttpClientConnectionManager();
			connMag.setMaxTotal(maxThreadsTotal);//总的连接数  
			connMag.setDefaultMaxPerRoute(maxThreadsPerHost);//每个host的最大连接数  
	        RequestConfig.Builder configBuilder = RequestConfig.custom();  
	        // 设置连接超时  
	        configBuilder.setConnectTimeout(MAX_TIMEOUT);  
	        // 设置读取超时  
	        configBuilder.setSocketTimeout(MAX_TIMEOUT);  
	        // 设置从连接池获取连接实例的超时  
	        configBuilder.setConnectionRequestTimeout(MAX_TIMEOUT);  
	        requestConfig = configBuilder.build();  
		}
		private HttpClientKit init(){
	        return t;
	    }
	}
	public static HttpClientKit init() {
		return initHttp.instance.init();
	} 
    public  String doGet(String url) {  
        return doGet(url, new HashMap<String, Object>());  
    }  
    /**
     * 发送 GET 请求（HTTP），K-V形式
     * @param url
     * @param params
     * @return
     */  
    @SuppressWarnings({ "deprecation", "resource" })
	public  String doGet(String url, Map<String, Object> params) {  
        String apiUrl = url;  
        StringBuffer param = new StringBuffer();  
        int i = 0;  
        for (String key : params.keySet()) {  
            if (i == 0)  
                param.append("?");  
            else  
                param.append("&");  
            param.append(key).append("=").append(params.get(key));  
            i++;  
        }  
        apiUrl += param;  
        String result = null;  
        HttpClient httpclient = new DefaultHttpClient();  
        try {  
            HttpGet httpPost = new HttpGet(apiUrl);  
            HttpResponse response = httpclient.execute(httpPost);  
            int statusCode = response.getStatusLine().getStatusCode();  
 
            LogKit.info("~执行状态码 : " + statusCode);
 
            HttpEntity entity = response.getEntity();  
            if (entity != null) {  
                InputStream instream = entity.getContent();  
                result = IOUtils.toString(instream, "UTF-8");  
            }  
        } catch (IOException e) {  
            e.printStackTrace();  
        }  
        return result;  
    }  
    
    public  String doPost(String apiUrl) {  
        return doPost(apiUrl, new HashMap<String, Object>());  
    }  
    /**
     * 发送 POST 请求（HTTP），K-V形式
     * @param apiUrl API接口URL
     * @param params 参数map
     * @return
     */  
    public  String doPost(String apiUrl, Map<String, Object> params) {  
        CloseableHttpClient httpClient = HttpClients.createDefault();  
        String httpStr = null;  
        HttpPost httpPost = new HttpPost(apiUrl);  
        CloseableHttpResponse response = null;  
        try {  
            httpPost.setConfig(requestConfig);  
            httpPost.setHeader("Connection", "close"); 
            List<NameValuePair> pairList = new ArrayList<>(params.size());  
            for (Map.Entry<String, Object> entry : params.entrySet()) {  
                NameValuePair pair = new BasicNameValuePair(entry.getKey(), entry  
                        .getValue().toString());  
                pairList.add(pair);  
            }  
            httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));  
            response = httpClient.execute(httpPost);  
//            int statusCode = response.getStatusLine().getStatusCode();  
//            LogKit.info("~执行状态码 : " + statusCode);
            HttpEntity entity = response.getEntity();  
            httpStr = EntityUtils.toString(entity, "UTF-8");  
        } catch (IOException e) {  
            e.printStackTrace();  
            httpStr=HTTPCLIENT_ERROR;
        } finally {  
            if (response != null) {  
                try {  
                    EntityUtils.consume(response.getEntity());  
                } catch (IOException e) {  
                    e.printStackTrace();  
                }  
            }  
        }  
        return httpStr;  
    }  
    /**
     * 发送 POST 请求（HTTP），K-V形式
     * @param apiUrl API接口URL
     * @param params 参数map
     * @return
     */  
    @SuppressWarnings("unchecked")
	public  String doPost(String apiUrl, Map<String, Object> params,Map<String,String> headers) {  
        CloseableHttpClient httpClient = HttpClients.createDefault();  
        String httpStr = null;  
        HttpPost httpPost = new HttpPost(apiUrl);  
        CloseableHttpResponse response = null;  
 
        try {  
            httpPost.setConfig(requestConfig);  
            httpPost.setHeader("Connection", "close"); 
            List<NameValuePair> pairList = new ArrayList<>(params.size());  
            for (Map.Entry<String, Object> entry : params.entrySet()) {  
                NameValuePair pair = new BasicNameValuePair(entry.getKey(), entry  
                        .getValue().toString());  
                pairList.add(pair);  
            }  
            if(headers!=null){
            	for (Object obj : headers.entrySet()) {    
    				Map.Entry<String, String> entry = (Map.Entry<String, String>) obj;  
    				String key=entry.getKey();
    				String value=entry.getValue();
    				httpPost.addHeader(key, value);
    		    }  
            }
            httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));  
            response = httpClient.execute(httpPost);  
            int statusCode = response.getStatusLine().getStatusCode();  
            LogKit.info("~执行状态码 : " + statusCode);
            HttpEntity entity = response.getEntity();  
            httpStr = EntityUtils.toString(entity, "UTF-8");  
        } catch (IOException e) {  
            e.printStackTrace();  
            httpStr=HTTPCLIENT_ERROR;
        } finally {  
            if (response != null) {  
                try {  
                    EntityUtils.consume(response.getEntity());  
                } catch (IOException e) {  
                    e.printStackTrace();  
                }  
            }  
        }  
        return httpStr;  
    }  
    /**
     * 发送 POST 请求（HTTP），JSON形式
     * @param apiUrl
     * @param json json对象
     * @return
     */  
    public  String doPostJson(String apiUrl, Object json) {  
        CloseableHttpClient httpClient = HttpClients.createDefault();  
        String httpStr = null;  
        HttpPost httpPost = new HttpPost(apiUrl);  
        CloseableHttpResponse response = null;  
        try {  
            httpPost.setConfig(requestConfig);  
            StringEntity stringEntity = new StringEntity(json.toString(),"UTF-8");//解决中文乱码问题  
            stringEntity.setContentEncoding("UTF-8");  
            stringEntity.setContentType("application/json");  
            httpPost.setEntity(stringEntity);  
            response = httpClient.execute(httpPost);  
            HttpEntity entity = response.getEntity();  
            System.out.println(response.getStatusLine().getStatusCode());  
            httpStr = EntityUtils.toString(entity, "UTF-8");  
        } catch (IOException e) {  
            e.printStackTrace();  
        } finally {  
            if (response != null) {  
                try {  
                    EntityUtils.consume(response.getEntity());  
                } catch (IOException e) {  
                    e.printStackTrace();  
                }  
            }  
        }  
        return httpStr;  
    }  

    public  String doPost(String apiUrl, Object obj) {  
        CloseableHttpClient httpClient = HttpClients.createDefault();  
        String httpStr = null;  
        HttpPost httpPost = new HttpPost(apiUrl);  
        CloseableHttpResponse response = null;  
        try {  
            httpPost.setConfig(requestConfig);  
            httpPost.setHeader("Connection", "close"); 
    		Class<?> clazz=obj.getClass();
    		Field[] fields = ReflectKit.getNeedFields(clazz);
            List<NameValuePair> pairList = new ArrayList<>(fields.length);  
            for (Field field : fields) {
      		  // 抑制Java对修饰符的检查
			      field.setAccessible(true);
			      String fieldName=field.getName();
			      Object o=ReflectKit.getFieldValue(obj, fieldName);
			      String value=null;
			      if(ReflectKit.isLangType(o)) {
			    	  value=ConvertUtils.toStr(o,"");
			      }else {
			    	  value=JSON.toJSONString(o);
			      }
			      NameValuePair pair = new BasicNameValuePair(fieldName ,value);  
	              pairList.add(pair); 
            }
            httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));  
            response = httpClient.execute(httpPost);  
            int statusCode = response.getStatusLine().getStatusCode();  
            LogKit.info("~执行状态码 : " + statusCode);
            HttpEntity entity = response.getEntity();  
            httpStr = EntityUtils.toString(entity, "UTF-8");  
        } catch (IOException e) {  
            e.printStackTrace();  
            httpStr=HTTPCLIENT_ERROR;
        } finally {  
            if (response != null) {  
                try {  
                    EntityUtils.consume(response.getEntity());  
                } catch (IOException e) {  
                    e.printStackTrace();  
                }  
            }  
        }  
        return httpStr;  
    }
    /**
     * 将文件提交至文件服务器
     */
    public String postFile(String apiUrl, File file) {
    	  CloseableHttpClient httpClient = HttpClients.createDefault();  
          String httpStr = null;  
          HttpPost httpPost = new HttpPost(apiUrl);  
          CloseableHttpResponse response = null;  
          try {  
              httpPost.setConfig(requestConfig);  
              httpPost.setHeader("Connection", "close"); 
              MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create();
              mEntityBuilder.addBinaryBody("file", file);
              httpPost.setEntity(mEntityBuilder.build()); 
              response = httpClient.execute(httpPost);  
              HttpEntity entity = response.getEntity();  
              httpStr = EntityUtils.toString(entity, "UTF-8");  
          } catch (IOException e) {  
              e.printStackTrace();  
              httpStr=HTTPCLIENT_ERROR;
          } finally {  
              if (response != null) {  
                  try {  
                      EntityUtils.consume(response.getEntity());  
                  } catch (IOException e) {  
                      e.printStackTrace();  
                  }  
              }  
          }  
          return httpStr;  
    }

}
