package com.ovopark.boot.kit.id;

import com.ovopark.boot.kit.id.snowflake.IdUtil;
import com.ovopark.boot.kit.id.snowflake.SnowflakeIdWorker;
import com.ovopark.boot.kit.id.uuid.GUIDUtils;
import com.ovopark.boot.kit.id.uuid.UUIdUtils;
/**
 * @ClassName:  IdKit   
 * @Description:TODO(Id工具类)   
 * @author: Remiel_Mercy 
 * @date:   2020年4月13日 下午2:50:57   
 *     
 * @Copyright: 2020 www.ovopark.com Inc. All rights reserved.
 */
public class IdKit {
	/**
	 * @Title: getEasyUUID   
	 * @Description: TODO(获取简单的uuid)   
	 * @param: @return      
	 * @return: String      
	 * @throws
	 */
	public static String getEasyUUID(){
		return UUIdUtils.getEasyUUID();
	}
	/**
	 * @Title: getIntricateUUID   
	 * @Description: TODO(获取复杂的uuid)   
	 * @param: @param bit
	 * @param: @return      
	 * @return: String      
	 * @throws
	 */
	public static String getIntricateUUID(String bit){
		return UUIdUtils.getIntricateUUID(bit);
	}
	/**
	 * @Title: getGuuid   
	 * @Description: TODO(获取Guuid)   
	 * @param: @return      
	 * @return: String      
	 * @throws
	 */
	public static String getGuuid(){
		GUIDUtils utils=new GUIDUtils();
		return utils.getGuuid();
	}
	
	/**
	 * @Title: getSnowflakeId   
	 * @Description: TODO(获取Snowflake id)   
	 * @param: @param workerId  工作ID (0~31) 
	 * @param: @param datacenterId 数据中心ID (0~31)
	 * @param: @return      
	 * @return: String      
	 * @throws
	 */
	public static String getSnowflakeId(long workerId, long datacenterId) {
		SnowflakeIdWorker idWorker = new SnowflakeIdWorker(workerId, datacenterId);
	    return String.valueOf(idWorker.nextId());
	}
}
