package com.ovopark.boot.kit.id.uuid;

import java.net.InetAddress;
import java.util.UUID;

import com.ovopark.boot.kit.id.IdKit;
import com.ovopark.boot.kit.lang.StrKit;


public class UUIdUtils {
	private static final int IP;
	private static String sep = "";
	private static short counter;
	private static final int JVM;
	private static final String default_bit="88";

	/**
	    * @Title: getEasyUUID
	    * @Description: TODO(获取简单的uuid)
	    * @param @return    参数
	    * @return String    返回类型
	    * @throws
	 */
	public static String getEasyUUID() {
		UUID uuid = UUID.randomUUID();
		return uuid.toString().replace("-", "");
	}
	/**
	    * @Title: getIntricateUUID
	    * @Description: TODO(复杂的uuid)
	    * @param @param bit 标识位
	    * @param @return    参数
	    * @return String    返回类型
	    * @throws
	 */
	public static String getIntricateUUID(String bit) {
		bit=StrKit.isBlank(bit)?default_bit:bit;
		return bit + format(getIP()) + sep + format(getJVM()) + sep + format(getHiTime()) + sep + format(getLoTime())
				+ sep + format(getCount());
	}

	private static String format(int intval) {
		String formatted = Integer.toHexString(intval);
		StringBuffer buf = new StringBuffer("00000000");
		buf.replace(8 - formatted.length(), 8, formatted);
		return buf.toString();
	}

	private static String format(short shortval) {
		String formatted = Integer.toHexString(shortval);
		StringBuffer buf = new StringBuffer("0000");
		buf.replace(4 - formatted.length(), 4, formatted);
		return buf.toString();
	}

	private static int getJVM() {
		return JVM;
	}

	private static short getCount() {
		synchronized (IdKit.class) {
			if (counter < 0)
				counter = 0;
			return counter++;
		}
	}

	private static int getIP() {
		return IP;
	}

	private static short getHiTime() {
		return (short) (int) (System.currentTimeMillis() >>> 32);
	}

	private static int getLoTime() {
		return (int) System.currentTimeMillis();
	}

	public static void main(String[] args) {
		for (int i = 0; i < 100; i++)
			System.out.println(getIntricateUUID(null));
	}

	static {
		int ipadd;
		try {
			ipadd = Integer.valueOf(InetAddress.getLocalHost().getAddress().toString());
		} catch (Exception e) {
			ipadd = 0;
		}
		IP = ipadd;
		counter = 0;
		JVM = (int) (System.currentTimeMillis() >>> 8);
	}
}
