package com.ovopark.boot.kit.json;

import com.fasterxml.jackson.core.JsonParser.Feature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.ovopark.boot.kit.lang.StrKit;

public class Jackson2Kit {
	 private static ObjectMapper objectMapper = new ObjectMapper();
	 static {
		    objectMapper.configure(Feature.ALLOW_COMMENTS, true);
	        objectMapper.configure(Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
	        objectMapper.configure(Feature.ALLOW_SINGLE_QUOTES, true);
	        objectMapper.configure(Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
	        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS,true);
	    	objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
			objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
	 }
	 
	public static <T> String objToJson(T obj) {
		if (obj == null) {
			return null;
		}
		try {
			return obj instanceof String ? (String) obj : objectMapper.writeValueAsString(obj);
		} catch (Exception e) {
			return null;
		}
	}
	
	public static <T> String objToJsonPretty(T obj) {
		if (obj == null) {
			return null;
		}
		try {
			return obj instanceof String ? (String) obj
					: objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
		} catch (Exception e) {
			return null;
		}
	}
	@SuppressWarnings("unchecked")
	public static <T> T json2Object(String json, Class<T> clazz) {
		if (StrKit.isEmpty(json) || clazz == null) {
			return null;
		}
		try {
			return clazz.equals(String.class) ? (T) json : objectMapper.readValue(json, clazz);
		} catch (Exception e) {
			return null;
		}
	}
	/**
	 * 
	 * @Title: json2Object   
	 * @Description: TODO(多泛型的转换)   
	 * @param: @param json
	 * @param: @param typeReference
	 * @param: @return      
	 * @return: T      
	 * @throws
	 */
	@SuppressWarnings("unchecked")
	public static <T> T json2Object(String json, TypeReference<?> typeReference) {
		if (StrKit.isEmpty(json) || typeReference == null) {
			return null;
		}
		try {
			return (T) (typeReference.getType().equals(String.class) ? json
					: objectMapper.readValue(json, typeReference));
		} catch (Exception e) {
			return null;
		}
	}

	public static <T> T json2Object(String json, Class<?> collectionClazz, Class<?>... elements) {
		JavaType javaType = objectMapper.getTypeFactory().constructParametricType(collectionClazz, elements);
		try {
			return objectMapper.readValue(json, javaType);
		} catch (Exception e) {
			return null;
		}
	}

}
