package com.ovopark.boot.kit.json.serializer;

import java.io.IOException;
import java.util.Date;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.ovopark.boot.kit.date.DateKit;

/**
 * 
    * @ClassName: CoCoJsonDateJsonDeserializer
    * @Description: TODO(Json时间转换器)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date  2019年1月2日 下午5:52:07 
    *
 */
public class CoCoJsonDateJsonDeserializer extends JsonDeserializer<Date>{

	@Override
	public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
		return DateKit.Str2DateTime(p.getText(), DateKit.getTimeFormat());
	}
		 
	 
}
