package com.ovopark.boot.kit.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.ovopark.boot.kit.lang.StrKit;

/**
 * 
 * @ClassName:  ReflectKit   
 * @Description:TODO(反射工具类)   
 * @author: Remiel_Mercy 
 * @date:   2019年1月8日 下午7:22:39   
 *     
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public class ReflectKit {
	/** 字段缓存 */
	protected static  Map<Class<?>, Field[]> fieldsCacheMap = new ConcurrentHashMap<Class<?>, Field[]>();
	protected String[] types1 = { "int", "java.lang.String", "boolean", "char", "float", "double", "long", "short",
			"byte" };
	protected String[] types2 = { "Integer", "java.lang.String", "java.lang.Boolean", "java.lang.Character",
			"java.lang.Float", "java.lang.Double", "java.lang.Long", "java.lang.Short", "java.lang.Byte" };
	/**
	 * 
	 * @Title: getFieldValue   
	 * @Description: TODO(获取制定某个字段的值)   
	 * @param: @param obj 对象
	 * @param: @param fieldName 字段名
	 * @param: @return      
	 * @return: Object      
	 * @throws
	 */
	public static Object getFieldValue(Object obj, String fieldName) {
		if(obj==null||StrKit.isBlank(fieldName)){
			return null;
		}
		Field[] fields=getFields(obj);
		return getFieldValue(obj,fields,fieldName);
	}
	
	/**
	 * 
	 * @Title: getField  
	 * @Description: TODO(获得一个类中所有字段列表，包括其父类中的字段)   
	 * @param: @param object
	 * @param: @return
	 * @return: Object      
	 * @throws
	 */
	public static Field[] getFields(Object object) {
	    Class<?> cls = object.getClass();
	    Field[] fields= fieldsCacheMap.get(cls);
		if (null != fields) {
			return fields;
		}
		fields = object.getClass().getDeclaredFields(); 
		fieldsCacheMap.put(cls, fields);
		return fields;
	}

	/**
	 * @Title: getFieldValue   
	 * @Description: TODO(获取字段值)   
	 * @param: @param object
	 * @param: @param fields
	 * @param: @param fieldName
	 * @param: @return      
	 * @return: Object      
	 * @throws
	 */
	private static  Object getFieldValue(Object object,Field[] fields,String fieldName){
		for (Field field : fields) {
			field.setAccessible(true);
			if (field.getName().equals(fieldName)) {
				try {
					return field.get(object);
				} catch (IllegalArgumentException e) {
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					e.printStackTrace();
				}
			}
		}
		return null;
	}
	
	public static <T> T clazzToBean(Class<T> clazz) {
		try {
			return clazz.newInstance();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	/**
	    * @Title: getNeedFields
	    * @Description: TODO(获取新增的ORM字段)
	    * @param @param clazz
	    * @param @return    参数
	    * @return Field[]    返回类型
	    * @throws
	 */
	public static Field[] getNeedFields(Class<?> clazz) {
	    Map<String,Object> list = new HashMap<String,Object>();
	    while ((null != clazz) && (clazz != Object.class)) {
	      Field[] fs = clazz.getDeclaredFields();
	      for (int i = 0; i < fs.length; i++) {
	        if (isIgnoredField(fs[i]))
	          continue;
	        if (list.containsKey(fs[i].getName()))
	          continue;
	        list.put(fs[i].getName(), fs[i]);
	      }
	      clazz = clazz.getSuperclass();
	    }
	    return (Field[])list.values().toArray(new Field[list.size()]);
	}
	/**
	    * @Title: isIgnoredField
	    * @Description: TODO(忽略的字段)
	    * @param @param f
	    * @param @return    参数
	    * @return boolean    返回类型
	    * @throws
	 */
	public static boolean isIgnoredField(Field f) {
	    if (Modifier.isStatic(f.getModifiers()))
	      return true;
	    if (Modifier.isFinal(f.getModifiers())) 
	      return true;
		return false;
	  }
	
	/**
	* 判断object是否为基本类型
	* @param object
	* @return
	*/
	public static boolean isBaseType(Object object) {
	    Class<?> className = object.getClass();
	    if (className.equals(java.lang.Integer.class) ||
	        className.equals(java.lang.Byte.class) ||
	        className.equals(java.lang.Long.class) ||
	        className.equals(java.lang.Double.class) ||
	        className.equals(java.lang.Float.class) ||
	        className.equals(java.lang.Character.class) ||
	        className.equals(java.lang.Short.class) ||
	        className.equals(java.lang.Boolean.class)) {
	        return true;
	    }
	    return false;
	}
	public static boolean isLangType(Object object) {
	    Class<?> className = object.getClass();
	    if (className.equals(java.lang.String.class) ||
	    	className.equals(java.lang.Integer.class) ||
	        className.equals(java.lang.Byte.class) ||
	        className.equals(java.lang.Long.class) ||
	        className.equals(java.lang.Double.class) ||
	        className.equals(java.lang.Float.class) ||
	        className.equals(java.lang.Character.class) ||
	        className.equals(java.lang.Short.class) ||
	        className.equals(java.lang.Boolean.class)) {
	        return true;
	    }
	    return false;
	}
}
