package com.ovopark.boot.kit.util.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
/**
 * 
 * @ClassName: ThreadPoolKit
 * @Description:TODO(线程池管理工具类，基于ThreadPoolExecutor封装)
 * @author: Remiel_Mercy
 * @date: 2019年8月12日 上午11:13:24
 * 
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public class ThreadPoolKit {

	private enum ThreadPoolKitLoader {
		instance;
		private ThreadPoolProxy proxy;

		ThreadPoolKitLoader() {
			proxy = new ThreadPoolProxy(5, 200, 1000);
		}

		private ThreadPoolProxy init() {
			return proxy;
		}
	}

	public static ThreadPoolProxy getThreadPoolProxy() {
		return ThreadPoolKitLoader.instance.init();
	}

	
	 public static class ThreadPoolProxy {
		private ThreadPoolExecutor poolExecutor;// 阿里巴巴规范手册推荐
		private int corePoolSize; // 设置核心池大小
		private int maximumPoolSize; // 设置线程池最大能接受多少线程
		private long keepAliveTime; // 当前线程数大于corePoolSize、小于maximumPoolSize时，超出corePoolSize的线程数的生命周期

		public ThreadPoolProxy(int corePoolSize, int maximumPoolSize, long keepAliveTime) {
			this.corePoolSize = corePoolSize;
			this.maximumPoolSize = maximumPoolSize;
			this.keepAliveTime = keepAliveTime;
		}

		// 对外提供一个执行任务的方法
		public void execute(Runnable r) {
			if (poolExecutor == null || poolExecutor.isShutdown()) {
				poolExecutor = new ThreadPoolExecutor(
						// 核心线程数量
						corePoolSize,
						// 最大线程数量
						maximumPoolSize,
						// 当线程空闲时，保持活跃的时间
						keepAliveTime,
						// 时间单元 ，毫秒级
						TimeUnit.MILLISECONDS,
						// 线程任务队列
						new LinkedBlockingQueue<Runnable>(),
						// 创建线程的工厂
						Executors.defaultThreadFactory());
			}
			poolExecutor.execute(r);
		}
	}
}
