/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.exception;

import java.util.HashMap;
import java.util.Map;

public class CoCoException
extends RuntimeException {
    private static final long serialVersionUID = -6103224412679113702L;
    private int errorCode;
    public static final Map<Integer, String> ERROR_CODE_MAP = new HashMap<Integer, String>();

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public CoCoException() {
    }

    public CoCoException(int errorCode) {
        super(ERROR_CODE_MAP.get(errorCode));
        this.errorCode = errorCode;
    }

    public CoCoException(Throwable cause) {
        super(cause);
    }

    public CoCoException(int errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
        ERROR_CODE_MAP.put(errorCode, message);
    }

    public CoCoException(int errorCode, Throwable cause) {
        super(ERROR_CODE_MAP.get(errorCode), cause);
        this.errorCode = errorCode;
    }

    public CoCoException(String message, Throwable cause) {
        super(message, cause);
    }

    public CoCoException(int errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
        ERROR_CODE_MAP.put(errorCode, message);
    }

    public String getErrorMessage() {
        return ERROR_CODE_MAP.get(this.errorCode);
    }
}

