/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.date;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateKit {
    static String TIME = "yyyy-MM-dd HH:mm:ss";
    static String OTHER_TIME = "yyyy/MM/dd HH:mm:ss";
    static String DATE = "yyyy-MM-dd";
    static String OTHER_DATE = "yyyy/MM/dd";
    static String SAMPLE_TIME = "yyyyMMddHHmmss";
    static String SAMPLE_DATE = "yyyyMMdd";
    static String HOUR_TIME = "yyyyMMddHH";
    static String SAMPLE_Month = "yyyy-MM";
    static String SAMPLE_HOUR = "yyyy-MM-dd HH";

    public static SimpleDateFormat getTimeFormat() {
        return new SimpleDateFormat(TIME);
    }

    public static SimpleDateFormat getOtherTimeFormat() {
        return new SimpleDateFormat(OTHER_TIME);
    }

    public static SimpleDateFormat getOtherDateFormat() {
        return new SimpleDateFormat(OTHER_DATE);
    }

    public static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat(DATE);
    }

    public static SimpleDateFormat getSampleTimeFormat() {
        return new SimpleDateFormat(SAMPLE_TIME);
    }

    public static SimpleDateFormat getSampleDateFormat() {
        return new SimpleDateFormat(SAMPLE_DATE);
    }

    public static SimpleDateFormat getHourDateFormat() {
        return new SimpleDateFormat(HOUR_TIME);
    }

    public static SimpleDateFormat getMonthDateFormat() {
        return new SimpleDateFormat(SAMPLE_Month);
    }

    public static SimpleDateFormat getHOURDateFormat() {
        return new SimpleDateFormat(SAMPLE_HOUR);
    }

    public static String DateTime2Str(Date date, SimpleDateFormat format) {
        return format.format(date);
    }

    public static Date Str2DateTime(String date, SimpleDateFormat format) {
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isValidDate(String str, SimpleDateFormat format) {
        try {
            Date date = format.parse(str);
            return str.equals(format.format(date));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int countDays(String date) {
        return DateKit.countDays(date, TIME);
    }

    public static int countDays(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    public static int countDays(String date, String format) {
        long t = Calendar.getInstance().getTime().getTime();
        Calendar c = Calendar.getInstance();
        c.setTime(DateKit.parse(date, format));
        long t1 = c.getTime().getTime();
        return (int)(t / 1000L - t1 / 1000L) / 3600 / 24;
    }

    public static Date getStartTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static boolean isSameDate(String s1, String s2) {
        return DateKit.isSameDate(s1, s2, DateKit.getTimeFormat());
    }

    public static boolean isSameDate(String s1, String s2, SimpleDateFormat format) {
        Date date1 = DateKit.Str2DateTime(s1, format);
        Date date2 = DateKit.Str2DateTime(s2, format);
        return DateKit.isSameDate(date1, date2);
    }

    public static boolean isSameDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        boolean isSameYear = cal1.get(1) == cal2.get(1);
        boolean isSameMonth = isSameYear && cal1.get(2) == cal2.get(2);
        boolean isSameDate = isSameMonth && cal1.get(5) == cal2.get(5);
        return isSameDate;
    }

    public static String getToday(SimpleDateFormat format) {
        Date date = new Date();
        String sdate = DateKit.DateTime2Str(date, format);
        return sdate;
    }

    public static String getBeforeDayByMonth(int month, SimpleDateFormat format) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -month);
        date = calendar.getTime();
        String sdate = DateKit.DateTime2Str(date, format);
        return sdate;
    }

    public static String getBeforeSDate() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        String sdate = DateKit.DateTime2Str(date, DateKit.getDateFormat());
        return sdate;
    }

    public static String getNextSDate() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        date = calendar.getTime();
        String sdate = DateKit.DateTime2Str(date, DateKit.getDateFormat());
        return sdate;
    }

    public static Date getBeforeDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return date;
    }

    public static Date getNextDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        date = calendar.getTime();
        return date;
    }

    public static String beforeMinuteToNowDate(int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -minute);
        SimpleDateFormat df = DateKit.getTimeFormat();
        return df.format(calendar.getTime());
    }

    public static String beforeSecondToNowDate(int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -second);
        SimpleDateFormat df = DateKit.getTimeFormat();
        return df.format(calendar.getTime());
    }

    public static LocalDateTime date2LocalDateTime() {
        Date date = new Date();
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime;
    }

    public static LocalDate date2LocalDate() {
        Date date = new Date();
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = instant.atZone(zoneId).toLocalDate();
        return localDate;
    }

    public static List<String> findDates(String sBegin, String sEnd) {
        ArrayList list = Lists.newArrayList();
        list.add(sBegin);
        Calendar calBegin = Calendar.getInstance();
        Date dBegin = DateKit.Str2DateTime(sBegin, DateKit.getDateFormat());
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        Date dEnd = DateKit.Str2DateTime(sEnd, DateKit.getDateFormat());
        calEnd.setTime(dEnd);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            Date now = calBegin.getTime();
            String sNow = DateKit.DateTime2Str(now, DateKit.getDateFormat());
            list.add(sNow);
        }
        return list;
    }

    public static String format2Str(String str, SimpleDateFormat format) {
        Date date = DateKit.Str2DateTime(str, format);
        String dateStr = format.format(date);
        return dateStr;
    }

    public static void main(String[] args) {
        List<String> list = DateKit.findDates("2018-03-12", "2018-11-26");
        System.out.println(list);
        System.out.println(DateKit.format2Str("2018-03-12 12:00:00", DateKit.getDateFormat()));
    }
}

