/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.http;

import com.alibaba.fastjson.JSON;
import com.ovopark.boot.kit.log.LogKit;
import com.ovopark.boot.kit.reflect.ReflectKit;
import com.ovopark.boot.utils.lang.ConvertUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientKit {
    private static PoolingHttpClientConnectionManager connMag;
    private static RequestConfig requestConfig;
    private static final int MAX_TIMEOUT = 10000;
    private static int maxThreadsTotal;
    private static int maxThreadsPerHost;
    static final String HTTPCLIENT_ERROR = "APIGETWAY_HTTP_ERROR";

    public static HttpClientKit init() {
        return initHttp.instance.init();
    }

    public String doGet(String url) {
        return this.doGet(url, new HashMap<String, Object>());
    }

    public String doGet(String url, Map<String, Object> params) {
        String apiUrl = url;
        StringBuffer param = new StringBuffer();
        int i = 0;
        for (String key : params.keySet()) {
            if (i == 0) {
                param.append("?");
            } else {
                param.append("&");
            }
            param.append(key).append("=").append(params.get(key));
            ++i;
        }
        apiUrl = apiUrl + param;
        String result = null;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpPost = new HttpGet(apiUrl);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            LogKit.info("~\u6267\u884c\u72b6\u6001\u7801 : " + statusCode);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream instream = entity.getContent();
                result = IOUtils.toString((InputStream)instream, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String doPost(String apiUrl) {
        return this.doPost(apiUrl, new HashMap<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(String apiUrl, Map<String, Object> params) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Connection", "close");
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            httpStr = HTTPCLIENT_ERROR;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(String apiUrl, Map<String, Object> params, Map<String, String> headers) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Connection", "close");
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            if (headers != null) {
                Iterator<Map.Entry<String, Object>> iterator = headers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> obj;
                    Map.Entry<String, Object> entry = obj = iterator.next();
                    String key = entry.getKey();
                    String value = (String)entry.getValue();
                    httpPost.addHeader(key, value);
                }
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            LogKit.info("~\u6267\u884c\u72b6\u6001\u7801 : " + statusCode);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            httpStr = HTTPCLIENT_ERROR;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPostJson(String apiUrl, Object json) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            httpPost.setConfig(requestConfig);
            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            System.out.println(response.getStatusLine().getStatusCode());
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(String apiUrl, Object obj) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Connection", "close");
            Class<?> clazz = obj.getClass();
            Field[] fields = ReflectKit.getNeedFields(clazz);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(fields.length);
            for (Field field : fields) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object o = ReflectKit.getFieldValue(obj, fieldName);
                String value = null;
                value = ReflectKit.isLangType(o) ? ConvertUtils.toStr(o, "") : JSON.toJSONString((Object)o);
                BasicNameValuePair pair = new BasicNameValuePair(fieldName, value);
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            LogKit.info("~\u6267\u884c\u72b6\u6001\u7801 : " + statusCode);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            httpStr = HTTPCLIENT_ERROR;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postFile(String apiUrl, File file) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String httpStr = null;
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        try {
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Connection", "close");
            MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create();
            mEntityBuilder.addBinaryBody("file", file);
            httpPost.setEntity(mEntityBuilder.build());
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            httpStr = HTTPCLIENT_ERROR;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    static {
        maxThreadsTotal = 100;
        maxThreadsPerHost = 5;
    }

    private static enum initHttp {
        instance;

        private HttpClientKit t = new HttpClientKit();

        private initHttp() {
            connMag = new PoolingHttpClientConnectionManager();
            connMag.setMaxTotal(maxThreadsTotal);
            connMag.setDefaultMaxPerRoute(maxThreadsPerHost);
            RequestConfig.Builder configBuilder = RequestConfig.custom();
            configBuilder.setConnectTimeout(10000);
            configBuilder.setSocketTimeout(10000);
            configBuilder.setConnectionRequestTimeout(10000);
            requestConfig = configBuilder.build();
        }

        private HttpClientKit init() {
            return this.t;
        }
    }
}

