/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.lang;

import java.util.List;

public class StrKit {
    public static final char C_SPACE = ' ';
    public static final char C_TAB = '\t';
    public static final char C_DOT = '.';
    public static final char C_SLASH = '/';
    public static final char C_BACKSLASH = '\\';
    public static final char C_CR = '\r';
    public static final char C_LF = '\n';
    public static final char C_UNDERLINE = '_';
    public static final char C_COMMA = ',';
    public static final char C_DELIM_START = '{';
    public static final char C_DELIM_END = '}';
    public static final String SPACE = " ";
    public static final String TAB = "\t";
    public static final String DOT = ".";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EMPTY = "";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String CRLF = "\r\n";
    public static final String UNDERLINE = "_";
    public static final String COMMA = ",";
    public static final String HTML_NBSP = "&nbsp;";
    public static final String HTML_AMP = "&amp";
    public static final String HTML_QUOTE = "&quot;";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    public static final String EMPTY_JSON = "{}";
    public static final int INDEX_NOT_FOUND = -1;

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean notBlank(String str) {
        return !StrKit.isBlank(str);
    }

    public static boolean notBlank(String ... strings) {
        if (strings == null || strings.length == 0) {
            return false;
        }
        for (String str : strings) {
            if (!StrKit.isBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean notNull(Object ... paras) {
        if (paras == null) {
            return false;
        }
        for (Object obj : paras) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof List) {
            return ((List)obj).size() == 0;
        }
        return false;
    }

    public static boolean isEmptyByTrim(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof List) {
            return ((List)obj).size() == 0;
        }
        if (obj instanceof String) {
            return ((String)obj).trim().equals(EMPTY);
        }
        return false;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(String str) {
        return false == StrKit.isEmpty(str);
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (inString == null) {
            return null;
        }
        if (oldPattern == null || newPattern == null) {
            return inString;
        }
        StringBuffer sbuf = new StringBuffer();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sbuf.append(inString.substring(pos, index));
            sbuf.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sbuf.append(inString.substring(pos));
        return sbuf.toString();
    }

    public static String subBefore(String str, String separator, boolean isLastSeparator) {
        int pos;
        if (StrKit.isEmpty(str) || separator == null) {
            return null == str ? null : str.toString();
        }
        if (separator.isEmpty()) {
            return EMPTY;
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String subAfter(String str, String separator, boolean isLastSeparator) {
        int pos;
        if (StrKit.isEmpty(str)) {
            return null == str ? null : str.toString();
        }
        if (separator == null) {
            return EMPTY;
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static boolean startWith(String s1, String s2) {
        if (StrKit.isBlank(s2) && !StrKit.isBlank(s1)) {
            return false;
        }
        return s2.equals(new String(s1.substring(s1.length() - 1, s1.length())));
    }

    public static boolean endWith(String s1, String s2) {
        if (StrKit.isBlank(s2) && !StrKit.isBlank(s1)) {
            return false;
        }
        return s2.equals(new String(s1.substring(0, 1)));
    }

    public static String shiftOutEnd2End(String s1, String s2) {
        return StrKit.shiftOut(s1, s2, s2);
    }

    public static String shiftOut(String str, String prefix, String suffix) {
        if (StrKit.isBlank(str)) {
            return str;
        }
        int from = 0;
        int to = str.length();
        String str2 = str.toString();
        if (StrKit.startWith(str2, prefix)) {
            from = prefix.length();
        }
        if (StrKit.endWith(str2, suffix)) {
            to -= suffix.length();
        }
        return str2.substring(from, to);
    }

    public static String concat(String name, Object ... paras) {
        StringBuffer sf = new StringBuffer(name);
        for (Object o : paras) {
            sf.append(o);
        }
        return sf.toString();
    }

    public static String insert(String s1, int number, String s2) {
        StringBuilder str = new StringBuilder(s1);
        int last = str.length();
        for (int i = last - number; i > 0; i -= number) {
            str.insert(i, s2);
        }
        return str.toString();
    }
}

