/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.kit.util.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolKit {
    public static ThreadPoolProxy getThreadPoolProxy() {
        return ThreadPoolKitLoader.instance.init();
    }

    public static class ThreadPoolProxy {
        private ThreadPoolExecutor poolExecutor;
        private int corePoolSize;
        private int maximumPoolSize;
        private long keepAliveTime;

        public ThreadPoolProxy(int corePoolSize, int maximumPoolSize, long keepAliveTime) {
            this.corePoolSize = corePoolSize;
            this.maximumPoolSize = maximumPoolSize;
            this.keepAliveTime = keepAliveTime;
        }

        public void execute(Runnable r) {
            if (this.poolExecutor == null || this.poolExecutor.isShutdown()) {
                this.poolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), Executors.defaultThreadFactory());
            }
            this.poolExecutor.execute(r);
        }
    }

    private static enum ThreadPoolKitLoader {
        instance;

        private ThreadPoolProxy proxy = new ThreadPoolProxy(5, 200, 1000L);

        private ThreadPoolProxy init() {
            return this.proxy;
        }
    }
}

