package com.ovopark.boot.kit.cache;

import java.util.Iterator;
import java.util.Map;

public interface CoCoCache<Key, Value> {
	public String getName();

	public Value get(Key key);

	public Map<? extends Key, ? extends Value> getAll(Iterator<? extends Key> keys);

	public boolean isPresent(Key key);

	public void put(Key key, Value value);

	public void putAll(Map<? extends Key, ? extends Value> entries);

	public void invalidate(Key key);

	public void invalidateAll(Iterator<? extends Key> keys);

	public void invalidateAll();

	public boolean isEmpty();

	public int size();

	public void clear();

	public Map<? extends Key, ? extends Value> asMap();
}
