package com.ovopark.boot.kit.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ovopark.boot.kit.http.IPKit;
/**
 * @ClassName:  ExecKit   
 * @Description:TODO(Process 工具类)   
 * @author: Remiel_Mercy 
 * @date:   2020年12月31日 上午11:04:45   
 *     
 * @Copyright: 2020 www.ovopark.com Inc. All rights reserved.
 */
public class ExecKit {

	protected final static Logger logger = LoggerFactory.getLogger(ExecKit.class);
	
	private static final String DEFAULT_CHARSET = "GBK";
	
	/**
	 * @Title: exec   
	 * @Description: TODO(执行命令)   
	 * @param: @param command
	 * @param: @return      
	 * @return: String      
	 * @throws
	 */
	public static String exec(String command) {
		if(IPKit.isWindowsOS()) {
			String[] commands = {"cmd.exe", "/c", command };
			return exec(commands);
		}else {
			String[] commands = { "/bin/sh", "-c", command };
			return exec(commands);
		}
	}
	
	/**
	 * @Title: getTcpSockets   
	 * @Description: TODO(获取当前host，port socket连接数)   
	 * @param: @param host 
	 * @param: @param port
	 * @param: @return      
	 * @return: String      
	 * @throws
	 */
	public static String getTcpSockets(String host,String port) {
		if(IPKit.isWindowsOS()) {
			//netstat -ant |find /i /c "172.18.76.1:1381"
			StringBuffer sf=new StringBuffer();
			sf.append("netstat -ant |find /i /c").append(" \"").append(host).append(":").append(port).append("\"");
			String[] commands = { "cmd.exe", "/c",sf.toString()};
			return exec(commands);
		}else {
			//"netstat -nat|grep -i '127.0.0.1:80'|wc -l"
			StringBuffer sf=new StringBuffer();
			sf.append("netstat -nat|grep -i").append("	'").append(host).append(":").append(port).append("'").append("|wc -l");
			String[] commands = { "/bin/sh", "-c", sf.toString()};
			return exec(commands);
		}
	}
	
	public static String exec(String[] commands) {
		try {
//			logger.info("~commands:{}",JacksonKit.toJSon(commands));
			Process process = Runtime.getRuntime().exec(commands);
			BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(),DEFAULT_CHARSET));
			String line = null;
			StringBuilder sb = new StringBuilder();
			while ((line = br.readLine()) != null) {
				sb.append(line + "\n");
			}
			String result=sb.toString();
//			logger.info("~result:{}",result);
			return result;
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
		
	}
	/**
	 * Windows执行本地命令行
	 * 测试ok
	 * @param cmd
	 * @param workpath  在此目录下执行
	 * @return
	 */
	 public static String executeLocalCmd(String cmd, File workpath) {  
		 try {  
			 String[] cmdA = { "cmd.exe", "/c", cmd };  
             Process process = null;
             if(workpath==null){
            	 process = Runtime.getRuntime().exec(cmdA);  
             }else{
            	 process = Runtime.getRuntime().exec(cmdA, null, workpath);  
             }
             LineNumberReader br = new LineNumberReader(new InputStreamReader(process.getInputStream(),DEFAULT_CHARSET));
             StringBuffer sb = new StringBuffer();  
             String line;  
             while ((line = br.readLine()) != null) {  
            	 sb.append(line).append("\n");  
             }  
             return sb.toString();  
         } catch (Exception e) {
         }  
         return null;  
     }  

	public static void main(String[] args) {
		StringBuffer sf=new StringBuffer();
		sf.append("netstat -nat|grep -i").append(" '").append("127.0.0.1").append(":").append("80").append("' ").append("|wc -l");
		System.out.println(sf.toString());
		String retult=executeLocalCmd("netstat -ano|find \"127.0.0.1:80\" /c",null);
		System.out.println("retult:"+retult);
		System.out.println(getTcpSockets("127.0.0.1","80"));
	}
}
