package com.ovopark.boot.kit.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.google.common.collect.Lists;

/**
 * 
    * @ClassName: DateKit
    * @Description: TODO(日期转化工具类)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年8月30日 下午4:47:29
 */
public class DateKit {
	static String TIME = "yyyy-MM-dd HH:mm:ss";
	static	String OTHER_TIME="yyyy/MM/dd HH:mm:ss";
	static	String DATE ="yyyy-MM-dd";
	static	String OTHER_DATE="yyyy/MM/dd";
	static	String SAMPLE_TIME="yyyyMMddHHmmss";
	static	String SAMPLE_DATE="yyyyMMdd";
	static	String HOUR_TIME = "yyyyMMddHH";
	static	String SAMPLE_Month="yyyy-MM";
	
	static	String SAMPLE_HOUR="yyyy-MM-dd HH";
	 
	public static SimpleDateFormat getTimeFormat(){ 
		return new SimpleDateFormat(TIME);
	}
	public static SimpleDateFormat getOtherTimeFormat() {
		return new SimpleDateFormat(OTHER_TIME);
	}
	public static SimpleDateFormat getOtherDateFormat() {
		return new SimpleDateFormat(OTHER_DATE);
	}
	public static SimpleDateFormat getDateFormat() {
		return new SimpleDateFormat(DATE);
	}
	public static SimpleDateFormat getSampleTimeFormat() {
		return new SimpleDateFormat(SAMPLE_TIME);
	}
	public static SimpleDateFormat getSampleDateFormat() {
		return new SimpleDateFormat(SAMPLE_DATE);
	}
	public static SimpleDateFormat getHourDateFormat(){
		return new SimpleDateFormat(HOUR_TIME);
	}
	public static SimpleDateFormat getMonthDateFormat(){
		return new SimpleDateFormat(SAMPLE_Month);
	}
	public static SimpleDateFormat getHOURDateFormat(){
		return new SimpleDateFormat(SAMPLE_HOUR);
	}
	
	
	public static String DateTime2Str(Date date,SimpleDateFormat format) {
		return format.format(date);
	}
	
	public static Date Str2DateTime(String date,SimpleDateFormat format) {
		try {
			return format.parse(date);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	/**
	    * @Title: isValidDate
	    * @Description: TODO(验证日期是不是制定格式)
	    * @param @param str
	    * @param @param format
	    * @param @return    参数
	    * @return boolean    返回类型
	    * @throws
	 */
    public static boolean isValidDate(String str,SimpleDateFormat format) {  
        try{  
            Date date = (Date)format.parse(str);  
            return str.equals(format.format(date));  
        }catch(Exception e){  
            return false;  
        }  
    } 
    /**
     * 使用用户格式提取字符串日期
     * 
     * @param strDate
     *            日期字符串
     * @param pattern
     *            日期格式
     * @return
     */
    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
    /**
     * 按默认格式的字符串距离今天的天数
     * 
     * @param date
     *            日期字符串
     * @return
     */
    public static int countDays(String date) {
    	return countDays(date,TIME);
    }

    /**
     * 2天之间的天数
     * @param date
     * @return
     */
    public static int countDays(Date date1,Date date2) {
        int days = (int) ((date2.getTime() - date1.getTime()) / (1000*3600*24));
        return days;
    }
    /**
     * 按用户格式字符串距离今天的天数
     * 
     * @param date
     *            日期字符串
     * @param format
     *            日期格式
     * @return
     */
    public static int countDays(String date, String format) {
        long t = Calendar.getInstance().getTime().getTime();
        Calendar c = Calendar.getInstance();
        c.setTime(parse(date, format));
        long t1 = c.getTime().getTime();
        return (int) (t / 1000 - t1 / 1000) / 3600 / 24;
    }
    
    /**
     * 获取一天的开始时间
     * @param date
     * @return
     */
    public static Date getStartTimeOfDay(Date date) {
    	 Calendar cal = Calendar.getInstance();
         cal.setTime(date);
         cal.set(Calendar.HOUR_OF_DAY, 0);
         cal.set(Calendar.MINUTE, 0);
         cal.set(Calendar.SECOND, 0);
         cal.set(Calendar.MILLISECOND, 0);
         return cal.getTime();
    }
    
    /**
     * 获取一天的结束时间
     * @param date
     * @return
     */
    public static Date getEndTimeOfDay(Date date) {
   	 Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        return cal.getTime();
   }
    
    public static boolean isSameDate(String s1, String s2) {
    	return isSameDate(s1,s2,getTimeFormat());
    }
    public static boolean isSameDate(String s1, String s2,SimpleDateFormat format) {
    	Date date1=Str2DateTime(s1,format);
    	Date date2=Str2DateTime(s2,format);
    	return isSameDate(date1,date2);
    }
 
    public static boolean isSameDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);

        boolean isSameYear = cal1.get(Calendar.YEAR) == cal2
                .get(Calendar.YEAR);
        boolean isSameMonth = isSameYear
                && cal1.get(Calendar.MONTH) == cal2.get(Calendar.MONTH);
        boolean isSameDate = isSameMonth
                && cal1.get(Calendar.DAY_OF_MONTH) == cal2
                        .get(Calendar.DAY_OF_MONTH);
        return isSameDate;
    }
    
    public static String getToday(SimpleDateFormat format) {
    	Date date=new Date();
    	String sdate=DateTime2Str(date,format);
    	return sdate;	    
    }
    
    public static String getBeforeDayByMonth(int month,SimpleDateFormat format) {
       	Date date=new Date();
    	Calendar calendar = Calendar.getInstance();
    	calendar.setTime(date);
    	calendar.add(Calendar.MONTH, -month);
    	date = calendar.getTime();
    	String sdate=DateTime2Str(date,format);
    	return sdate;	      
    }
    
    
    public static String getBeforeSDate() {
    	Date date=new Date();
    	Calendar calendar = Calendar.getInstance();
    	calendar.setTime(date);
    	calendar.add(Calendar.DAY_OF_MONTH, -1); //今天的时间减一天
    	date = calendar.getTime();
    	String sdate=DateTime2Str(date,getDateFormat());
    	return sdate;	    
    }
    
    public static String getBeforeSDate(int day) {
    	Date date=new Date();
    	Calendar calendar = Calendar.getInstance();
    	calendar.setTime(date);
    	calendar.add(Calendar.DAY_OF_MONTH, -day); //今天的时间减一天
    	date = calendar.getTime();
    	String sdate=DateTime2Str(date,getDateFormat());
    	return sdate;	    
    }
    
    public static String getNextSDate() {
    	Date date=new Date();
    	Calendar calendar = Calendar.getInstance();
    	calendar.setTime(date);
    	calendar.add(Calendar.DAY_OF_MONTH, +1); //今天的时间加一天
    	date = calendar.getTime();
    	String sdate=DateTime2Str(date,getDateFormat());
    	return sdate;	    
    }
    
    public static Date getBeforeDate(Date date) {
    	Calendar calendar = Calendar.getInstance();
    	calendar.setTime(date);
    	calendar.add(Calendar.DAY_OF_MONTH, -1); //今天的时间减一天
    	date = calendar.getTime();
    	return date;	    
    }
    public static Date getNextDate(Date date) {
    	Calendar calendar = Calendar.getInstance();
    	calendar.setTime(date);
    	calendar.add(Calendar.DAY_OF_MONTH, +1); //今天的时间加一天
    	date = calendar.getTime();
    	return date;	    
    }
	 public static String beforeMinuteToNowDate(int minute) {
		 Calendar calendar = Calendar.getInstance();
		 calendar.add(Calendar.MINUTE, -minute);// 几分钟之前的时间
		 SimpleDateFormat df = DateKit.getTimeFormat();
		 return df.format(calendar.getTime());
	 }
	 public static String beforeSecondToNowDate(int second) {
		 Calendar calendar = Calendar.getInstance();
		 calendar.add(Calendar.SECOND, -second);// 几秒之前的时间
		 SimpleDateFormat df = DateKit.getTimeFormat();
		 return df.format(calendar.getTime());
	 }
	 public static LocalDateTime date2LocalDateTime(){
		 Date date = new Date();
	     Instant instant = date.toInstant();
	     ZoneId zoneId = ZoneId.systemDefault();
	     LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
	     return localDateTime;
	 }
	 public static LocalDate date2LocalDate(){
		 Date date = new Date();
	     Instant instant = date.toInstant();
	     ZoneId zoneId = ZoneId.systemDefault();
	     LocalDate localDate = instant.atZone(zoneId).toLocalDate();
	     return localDate;
	 }
	 public static List<String> findDates(String sBegin, String sEnd ){
		 List<String> list=Lists.newArrayList();
		 list.add(sBegin);
		 Calendar calBegin = Calendar.getInstance();  
		  // 使用给定的 Date 设置此 Calendar 的时间  
		 Date dBegin=Str2DateTime(sBegin,getDateFormat());
		 calBegin.setTime(dBegin);  
		 Calendar calEnd = Calendar.getInstance();  
		 Date dEnd=Str2DateTime(sEnd,getDateFormat());
		  // 使用给定的 Date 设置此 Calendar 的时间  
		 calEnd.setTime(dEnd);  
		  // 测试此日期是否在指定日期之后  
		  while (dEnd.after(calBegin.getTime()))  
		  {  
		   // 根据日历的规则，为给定的日历字段添加或减去指定的时间量  
		   calBegin.add(Calendar.DAY_OF_MONTH, 1);  
		   Date now=calBegin.getTime();
		   String sNow=DateTime2Str(now, getDateFormat());
		   list.add(sNow);  
		  } 
		 return list;
	 }
	 
	/**
	 * 在日期上增加数个整年
	 *
	 * @param date
	 *            日期
	 * @param n
	 *            要增加的年数
	 * @return
	 */
	public static Date addYear(Date date, int n) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.YEAR, n);
		return cal.getTime();
	}

	/**
	 * 在日期上增加数个整月
	 *
	 * @param date
	 *            日期
	 * @param n
	 *            要增加的月数
	 * @return
	 */
	public static Date addMonth(Date date, int n) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.MONTH, n);
		return cal.getTime();
	}

	/**
	 * 在日期上增加天数
	 *
	 * @param date
	 *            日期
	 * @param n
	 *            要增加的天数
	 * @return
	 */
	public static Date addDay(Date date, int n) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.DATE, n);
		return cal.getTime();
	}

	public static Date addHour(Date date, int n) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.HOUR, n);
		return cal.getTime();
	}

	public static Date addMinute(Date date, int n) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.MINUTE, n);
		return cal.getTime();
	}

	public static Date addSecond(Date date, int n) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.SECOND, n);
		return cal.getTime();
	}

	public static String addSecond(String time, int n) {
		Calendar cal = Calendar.getInstance();
		Date date = Str2DateTime(time, getTimeFormat());
		cal.setTime(date);
		cal.add(Calendar.SECOND, n);
		return DateTime2Str(cal.getTime(), getTimeFormat());
	}

	public static String format2Str(String str, SimpleDateFormat format) {
		Date date = Str2DateTime(str, format);
		String dateStr = format.format(date);
		return dateStr;
	}
	/**
	 * @Title: getDifferenceTime   
	 * @Description: TODO(获取时间差 秒)   
	 * @param: @param startTime
	 * @param: @param endTime
	 * @param: @return      
	 * @return: Long      
	 * @throws
	 */
	public static Long getDifferenceTime(String startTime,String endTime) {
		return getDifferenceTime(Str2DateTime(startTime,getTimeFormat()),Str2DateTime(endTime,getTimeFormat()));
	}
	
	/**
	 * @Title: getDifferenceTime   
	 * @Description: TODO(获取时间差 秒)   
	 * @param: @param startTime
	 * @param: @param endTime
	 * @param: @return      
	 * @return: Long      
	 * @throws
	 */
	public static Long getDifferenceTime(Date startTime,Date endTime) {
	     long diff = endTime.getTime() - startTime.getTime();
	     long s = diff / 1000;
	     return s;
	}
	/**
	 * 获取上周周一（第一天是周一）
	 *
	 * @return
	 */
	public static String getPreviousMonday() {
	    Calendar cal = Calendar.getInstance();
	    // 将每周第一天设为星期一，默认是星期天
	    cal.setFirstDayOfWeek(Calendar.MONDAY);
	    cal.add(Calendar.DATE, -1 * 7);
	    cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);

	    cal.set(Calendar.HOUR_OF_DAY, 0);
	    cal.set(Calendar.MINUTE, 0);
	    cal.set(Calendar.SECOND, 0);
	    cal.set(Calendar.MILLISECOND, 0);
    	String sdate=DateTime2Str(cal.getTime(),getDateFormat());
    	return sdate;	 
	}
	
	public static String getPreviousMonday(int week) {
	    Calendar cal = Calendar.getInstance();
	    // 将每周第一天设为星期一，默认是星期天
	    cal.setFirstDayOfWeek(Calendar.MONDAY);
	    cal.add(Calendar.DATE, -week * 7);
	    cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);

	    cal.set(Calendar.HOUR_OF_DAY, 0);
	    cal.set(Calendar.MINUTE, 0);
	    cal.set(Calendar.SECOND, 0);
	    cal.set(Calendar.MILLISECOND, 0);
    	String sdate=DateTime2Str(cal.getTime(),getDateFormat());
    	return sdate;	 
	}
	
	/**
	 * 获取上周周日（第一天是周一）
	 * @return
	 */
	public static String getPreviousSunday() {
	    Calendar cal = Calendar.getInstance();
	    //将每周第一天设为星期一，默认是星期天
	    cal.setFirstDayOfWeek(Calendar.MONDAY);
	    cal.add(Calendar.DATE, -1*7);
	    cal.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);

	    cal.set(Calendar.HOUR_OF_DAY, 0);
	    cal.set(Calendar.MINUTE, 0);
	    cal.set(Calendar.SECOND, 0);
	    cal.set(Calendar.MILLISECOND, 0);
		String sdate=DateTime2Str(cal.getTime(),getDateFormat());
    	return sdate;	
	}
	public static String getPreviousSunday(int week) {
	    Calendar cal = Calendar.getInstance();
	    //将每周第一天设为星期一，默认是星期天
	    cal.setFirstDayOfWeek(Calendar.MONDAY);
	    cal.add(Calendar.DATE, -week*7);
	    cal.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);

	    cal.set(Calendar.HOUR_OF_DAY, 0);
	    cal.set(Calendar.MINUTE, 0);
	    cal.set(Calendar.SECOND, 0);
	    cal.set(Calendar.MILLISECOND, 0);
		String sdate=DateTime2Str(cal.getTime(),getDateFormat());
    	return sdate;	
	}
	/**
	 * 获取上个月第1天
	 *
	 * @return
	 */
	public static String getLastMonthFirst() {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.MONTH, -1);
		cal.set(Calendar.DAY_OF_MONTH,1);
    	String sdate=DateTime2Str(cal.getTime(),getDateFormat());
    	return sdate;	 
	}
	
	public static String getLastMonthFirst(int month) {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.MONTH, -month);
		cal.set(Calendar.DAY_OF_MONTH,1);
    	String sdate=DateTime2Str(cal.getTime(),getDateFormat());
    	return sdate;	 
	}
	
	/**
	 *  获取上个月最后天
	 *
	 * @return
	 */
	public static String getLastMonthEnd() {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.DAY_OF_MONTH, 0);
    	String sdate=DateTime2Str(cal.getTime(),getDateFormat());
    	return sdate;	 
	}
	public static String getLastMonthEnd(int month) {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.MONTH, 1-month);
		cal.set(Calendar.DAY_OF_MONTH, 0);
    	String sdate=DateTime2Str(cal.getTime(),getDateFormat());
    	return sdate;	 
	}
    public static void main(String[] args) {
//    	String s1="2018-09-12 00:00:00";
//    	String s2="2018-09-12";
//		System.out.println(isSameDate(s1,s2));
//		Date d=new Date();
//		System.out.println(getBeforeDate(d));
//		System.out.println(getNextDate(d));
//    	List<String> list=findDates("2018-03-12","2018-11-26");
//    	System.out.println(list);
//    	System.out.println(format2Str("2018-03-12 12:00:00",getDateFormat()));
//    	System.out.println(addSecond("2018-03-12 12:00:00",60));
//    	System.out.println(getDifferenceTime("2018-03-12 12:02:00","2018-03-12 12:01:03"));
//    	System.out.println(getBeforeSDate());
//    	System.out.println(getBeforeSDate(2));
//    	System.out.println(getPreviousMonday());
//    	System.out.println(getPreviousMonday(2));
//    	System.out.println(getPreviousSunday());
//    	System.out.println(getPreviousSunday(2));
//    	System.out.println(getLastMonthFirst());
//    	System.out.println(getLastMonthFirst(2));
//    	System.out.println(getLastMonthEnd());
//    	System.out.println(getLastMonthEnd(2));
    	String s ="2022-06-25 10:42:00";
    	Date date =Str2DateTime(s,getTimeFormat());
    	System.out.println(addHour(date, 7));
	}
}
