package com.ovopark.boot.kit.dc;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import com.ovopark.boot.common.entity.CurrentUser;
import com.ovopark.boot.kit.http.OvoparkHttpClientKit;
import com.ovopark.boot.kit.json.Jackson2Kit;
import com.ovopark.boot.kit.lang.StrKit;
import com.ovopark.boot.utils.lang.ConvertUtils;

/**
 * @ClassName:  DcTokenKit   
 * @Description:TODO(token 解析工具类，兼容新老token)   
 * @author: Remiel_Mercy 
 * @date:   2020年10月19日 下午1:26:21   
 *     
 * @Copyright: 2020 www.ovopark.com Inc. All rights reserved.
 */
public class DcTokenKit {
	
	private static OvoparkHttpClientKit httpCilent=OvoparkHttpClientKit.init();
	
	static final String authenticator="authenticator";
	static final String ovoAuthorization="Ovo-Authorization";
	/**
	 * 新token解析
	 */
	static final String parseTokenUrl="/ovopark-sso/token/parseToken";
	/**
	 * 老token解析
	 */
	static final  String getUserByTokenUrl="/api/business/base/user/v1/getUserByToken";
	
	
	private final static String formal="formal";
	
	private final static String prod="prod";
	
	
	public enum TokenEnvironment {
		old_dev("old_dev", "http://test.business.ovopark.com"),//开发环境
		old_test("old_test", "http://test.business.ovopark.com"),//测试环境
		old_prod("old_prod", "http://business.ovopark.com"),//生产环境
		new_dev("new_dev", "http://47.96.139.143:8819"),//开发环境
		new_test("new_test", "http://47.96.139.143:8819"),//测试环境
		new_prod("new_prod", "http://47.96.139.143:8819");//生产环境
		private String key;  
	    private String value;  
	    // 构造方法  
	    private TokenEnvironment(String key, String value) {  
	        this.key = key;  
	        this.value = value;  
	    } 
	    //获取枚举定义的表达式
	    public static String getValue(String key) {  
	        for (TokenEnvironment c : TokenEnvironment.values()) {  
	            if (c.getKey().equals(key) ) {  
	                return c.value;  
	            }  
	        }  
	        return null;  
	    }
		public String getKey() {
			return key;
		}
		public void setKey(String key) {
			this.key = key;
		}
		public String getValue() {
			return value;
		}
		public void setValue(String value) {
			this.value = value;
		}
	}
	/**
	 * @Title: getCurrentUser   
	 * @Description: TODO(根据环境获取用户对象)   
	 * @param: @param request
	 * @param: @param environment
	 * @param: @return      
	 * @return: CurrentUser      
	 * @throws
	 */
	public static CurrentUser getCurrentUser(HttpServletRequest request,String environment ) {
		String oldToken=request.getHeader(authenticator);
		String newToken=request.getHeader(ovoAuthorization);
		boolean isNewToken=!StrKit.isBlank(newToken);
		
		CurrentUser user=new CurrentUser();
		user.setAuthenticator(oldToken);
		user.setOvoAuthorization(newToken);
		user.setNewToken(isNewToken);
		
		Map<String,Object> data=Maps.newHashMap();
		environment=environment.equals(formal)?prod:environment;
		if(isNewToken) {
			Map<String, Object> params=Maps.newHashMap();
			params.put("token", newToken);
			environment="new_"+environment;
			String url=TokenEnvironment.getValue(environment)+parseTokenUrl;
			String result=httpCilent.doGet(url, params);
			data=Jackson2Kit.json2Object(result, new TypeReference<Map<String,Object>>() {});
			user.setUserId(ConvertUtils.toInt(data.get("userId")));
		}else {
			Map<String, Object> headers=Maps.newHashMap();
			headers.put("authenticator", oldToken);
			environment="old_"+environment;
			String url=TokenEnvironment.getValue(environment)+getUserByTokenUrl;
			String result=httpCilent.doGet(url, Maps.newHashMap(), headers);
			data=Jackson2Kit.json2Object(result, new TypeReference<Map<String,Object>>() {});
			user.setUserId(ConvertUtils.toInt(data.get("id")));
		}
		user.setUserName(ConvertUtils.toStr(data.get("userName")));
		user.setGroupId(ConvertUtils.toInt(data.get("groupId")));
		return user;
	}
	
	
	public static CurrentUser getUser(String url,String newToken) {
		Map<String, Object> params=Maps.newHashMap();
		params.put("token", newToken);
		String result=httpCilent.doGet(url, params);
		Map<String,Object> data=Jackson2Kit.json2Object(result, new TypeReference<Map<String,Object>>() {});
		CurrentUser user=new CurrentUser();
		user.setOvoAuthorization(newToken);
		user.setNewToken(true);
		user.setUserId(ConvertUtils.toInt(data.get("userId")));
		user.setUserName(ConvertUtils.toStr(data.get("userName")));
		user.setGroupId(ConvertUtils.toInt(data.get("groupId")));
		return user;
	}

}
