package com.ovopark.boot.kit.function;

import java.util.List;
import java.util.function.Supplier;

import com.ovopark.boot.common.code.CommonApiReturnCode;
import com.ovopark.boot.common.code.support.ApiCodeResult;
import com.ovopark.boot.common.plugin.activerecord.GG;


public class OptionalKit {
	/**
     * 忽略NullPointerException的获取
     * @param supplier
     * @param <T>
     * @return 如果有空指针，返回null
     */
    public static <T> T orNull(Supplier<T> supplier) {
        try {
        	if(supplier instanceof List) {
        		
        	}
            return supplier.get();
        } catch (NullPointerException e) {
            return null;
        }
    }

   /**
     * 忽略NullPointerException的获取
     *
     * @param supplier
     * @param or
     * @param <T>
     * @return 如果有空指针，返回or
     */
    public static <T> T or(Supplier<T> supplier, T or) {
        try {
            T t = supplier.get();
            if (t != null) {
                return t;
            }
            return or;
        } catch (NullPointerException e) {
            return or;
        }
    }
    
    
    
    public static void main(String[] args) {
    	GG<?> gg=null;
    	System.out.println(OptionalKit.orNull(() ->gg.getCode()));
    	GG<?> gg2=ApiCodeResult.success();
    	System.out.println(OptionalKit.orNull(() ->gg2.getCode()));
	}
    
}
