package com.ovopark.boot.kit.http;

import java.net.URI;

import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
/**
 * @ClassName:  HttpDeleteKit   
 * @Description:TODO(HttpClient 默认的HttpDelete不支持setEntity操作，重写HttpDelete方法)   
 * @author: Remiel_Mercy 
 * @date:   2019年9月17日 下午4:22:53   
 *     
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public class HttpDeleteKit extends HttpEntityEnclosingRequestBase {
	public static final String METHOD_NAME = "DELETE";

	@Override
	public String getMethod() {
		return METHOD_NAME;
	}

	public HttpDeleteKit(final String uri) {
		super();
		setURI(URI.create(uri));
	}

	public HttpDeleteKit(final URI uri) {
		super();
		setURI(uri);
	}

	public HttpDeleteKit() {
		super();
	}
}
